/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.AffineTransform;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Required;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.TransformImpl;

/**
 * @See {@link TransformImpl} Implements Transform
 * @See {@link DefaultTransform} Implements Transform, Move, Rotate, Scale
 * @author Toni Kalajainen
 */
@Single
@Required
public interface Transform extends ElementHandler {

    /**
     * Get transform that transforms element coordinate to canvas coordinates.
     * May return internal state objects, clients must not assume that the
     * returned values are freely modifiable.
     * 
     * @param e
     * @return
     */
    AffineTransform getTransform(IElement e);

    /**
     * 
     * @param e
     * @param at
     */
    void setTransform(IElement e, AffineTransform at);

}
