/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;

/**
 * Scene graph node update handler of an element.
 * 
 * <p>
 * This handler is responsible for making sure that the scene graph is in sync
 * with the element's current state.
 * 
 * <p>
 * An element may have multiple scene graph handlers. Painting order of the
 * scene graph nodes is defined by the z-indexes given to the nodes created by
 * each {@link SceneGraph} handler.
 * 
 * @author J-P Laine
 * 
 * @see {@link G2DNode} for scene graph
 * @see ElementPainter
 */
public interface SceneGraph extends ElementHandler {

    /**
     * Updates the renderable representation of the specified element, i.e. its
     * scene graph parts to match the current state of the element.
     * 
     * <p>
     * This method will be called whenever the g2d framework decides that an
     * element is dirty. This means that implementations must be prepared to
     * have this method be called multiple times.
     * 
     * <p>
     * Generally implementations should create a scene graph node or nodes only
     * on the first invocation, store that in the element with a
     * {@link SceneGraphNodeKey} and on each call initialize the created
     * node/nodes with the values stored in the element.
     * 
     * @param e element to update into the scene graph
     * @param parent scene graph parent node for this element
     * 
     * TODO: the method is badly named since it can be invoked multiple
     * times. initOrUpdate would be more suitable but that just sounds
     * bad and the whole thing feels like bad design anyway.
     */
    void init(final IElement e, final G2DParentNode parent);

    /**
     * Remove any scene graph node references from the specified element and
     * from the scene graph.
     * 
     * @param e the element whose scene graph references to clean up
     */
    void cleanup(final IElement e);

}
