/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.impl.Resizeable;

/**
 * This interface is implemented by all elements whose internal size can 
 * be modified. 
 * 
 * @See {@link InternalSize} Handler for acquiring internal size of an element
 * @See {@link Resizeable} size can be changed by user
 * @author Toni Kalajainen
 */
@Single
public interface Resize extends ElementHandler, InternalSize {
	
	/**
	 * Modify the size of 
	 * @param e
	 * @param ctx
	 * @param newSize
	 */
	void resize(IElement e, Rectangle2D newSize);
	
	/**
	 * Returns width/height ratio if dimensions of the element are uniform, and
	 * null if not.
	 *  
	 * @return aspect ratio or null 
	 */
	Double getFixedAspectRatio(IElement e);
	
	/**
	 * Get minimum size if one exists
	 * @param e element
	 * @return the minimum size or null
	 */
	Rectangle2D getMinimumSize(IElement e);
	
	/**
	 * Get the maximum size of the element
	 * @param e element
	 * @return the maximum size or null
	 */
	Rectangle2D getMaximumSize(IElement e);
	
}
