/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.AbstractClickable;
import org.simantics.g2d.element.handler.impl.ClickableImpl;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * Clickable Element
 * 
 * 
 * @See {@link ClickableImpl}
 * @See {@link AbstractClickable} 
 * @author Toni Kalajainen
 */
public interface Clickable extends ElementHandler {

	public static final ClickableImpl INSTANCE = ClickableImpl.INSTANCE;
	
	// TODO PressStatus should be a variable of the viewport, not the diagram
	public static enum PressStatus { 
		NORMAL,  // not pressed 
		HOVER,   // not pressed but mouse is hovering over the element
		HELD,    // pressed but mouse is not hovering over the element
		PRESSED  // pressed and mouse is hovering over the element
		};
	
	public interface ClickListener {
		void onClick(IElement e, ICanvasContext ctx);
	}
	
	PressStatus getPressStatus(IElement e, ICanvasContext ctx);

	// IMPL Note! Invocation must be thread safe (canvas thread is not guaranteed)
	void addListener(IElement e, ICanvasContext ctx, IThreadWorkQueue thread, ClickListener listener);
	
	// IMPL Note! Invocation must be thread safe (canvas thread is not guaranteed)
	void removeListener(IElement e, ICanvasContext ctx, IThreadWorkQueue thread, ClickListener listener);
	
}
