/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.impl.Element;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * Element is an object on a diagram. Element is part of one diagram.
 * <p>
 * Element variables describe visual properties of the element.
 * 
 * Variables (all of them) may be cloned, and serialized.
 * Do not put non-visualization specific variables in element, e.g. Canvas Specific
 * variables.
 * 
 * Use DiagramParticipant to write _canvas_specific_variables_ e.g.
 *      DiagramParticipant dp = ctx.getSingleItem(DiagramParticipant.class);
 *      dp.setElementHint(...);
 *      dp.setDiagramHint(...);
 * 
 * Note! all values should be treated as if they are immutable.
 * 
 * @see ElementUtils
 * @see Element
 * @author Toni Kalajainen
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface IElement extends IHintContext {

    /**
     * @return
     */
    ElementClass getElementClass();

    /**
     * Returns the diagram this element is directly a part of.
     * 
     * @return the diagram
     */
    IDiagram getDiagram();

    /**
     * Looks whether this element is a a direct part of a diagram.
     * 
     * @return <code>null</code> if not a direct part of a diagram
     */
    IDiagram peekDiagram();

    /**
     * (INTERNAL!) Invoked as a notification when this element is added to a
     * diagram or removed from a diagram.
     * 
     * @param diagram
     *            diagram or <code>null</code> if the element was removed from a
     *            diagram
     */
    void addedToDiagram(IDiagram diagram);

    /**
     * Destroys the element from the world. Notifies all life-cycle handlers
     * through {@link LifeCycle#onElementDestroyed(IElement)} of the event.
     */
    void destroy();

    /**
     * Silently disposes of the element without performing any {@link LifeCycle}
     * notifications.
     */
    void dispose();

}
