/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas;

import org.simantics.g2d.canvas.impl.SGNodeReflection.SGInit;

/**
 * Specifies the scene graph node which will be given to an {@link SGInit}
 * annotated method in an {@link ICanvasParticipant}.
 * 
 * @author Tuukka Lehtonen
 */
public enum SGDesignation {
    /**
     * Indicates that {@link SGInit} wants to create nodes in the control space,
     * i.e. nodes that are not affected by the general user viewing transform.
     */
    CONTROL,

    /**
     * Indicates that {@link SGInit} wants to create nodes in the canvas (user)
     * space, i.e. nodes that are affected by the general user viewing
     * transform.
     */
    CANVAS,
}
