package org.simantics.filesystem.services.sizetracker;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.function.Consumer;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public interface SizeTracker extends Closeable {

	Path path();
	long size();

	void addListener(Consumer<SizeChangeEvent> listener);
	void removeListener(Consumer<SizeChangeEvent> listener);

}
