/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

import org.simantics.compressions.impl.CompressingOutputStream;
import org.simantics.fastlz.FastLZ;


/**
 * @author Hannu Niemist&ouml;
 */
public class FastLZOutputStream extends CompressingOutputStream {

    public FastLZOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public FastLZOutputStream(FileOutputStream stream) {
        super(stream);
    }

    public FastLZOutputStream(OutputStream stream) {
        super(stream);
    }

    public FastLZOutputStream(OutputStream stream, WritableByteChannel channel) {
        super(stream, channel);
    }

    @Override
    protected int compressBound(int inputSize) {
        return FastLZ.compressBound(inputSize);
    }

    @Override
    protected int compress(ByteBuffer uncompressed, int uncompressedOffset, int uncompressedSize,
            ByteBuffer compressed, int compressedOffset) {
        return FastLZ.compressBuffer(uncompressed, uncompressedOffset, uncompressedSize, compressed, compressedOffset);
    }

    protected ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

}
