/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz;

/**
 * @author Tuukka Lehtonen
 */
public enum OSType {
    APPLE, LINUX, SUN, WINDOWS, UNKNOWN;

    public static OSType calculate() {
        String osName = System.getProperty("os.name");
        assert osName != null;
        osName = osName.toLowerCase();
        if (osName.startsWith("mac os x"))
            return APPLE;
        if (osName.startsWith("windows"))
            return WINDOWS;
        if (osName.startsWith("linux"))
            return LINUX;
        if (osName.startsWith("sun"))
            return SUN;
        return UNKNOWN;
    }
}