/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fastlz.h"

char* uncompressed;
int uncompressedCapacity;
int position;
int uncompressedSize;
char* compressed;
int compressedCapacity;

FILE* handle;

void initRead(FILE* _handle) {
    uncompressed = 0;
    uncompressedCapacity = 0;
    position = 0;
    uncompressedSize = 0;    
    compressed = malloc(8);
    compressedCapacity = 8;
    handle = _handle;
}

void deinitRead() {
    free(uncompressed);
    uncompressed = 0;
    free(compressed);
    compressed = 0;
    handle = 0;
}

void fillBuffer() {
    int compressedSize;

    fread(compressed, 8, 1, handle);
    compressedSize = ((int*)compressed)[0];
    uncompressedSize = ((int*)compressed)[1];
    
    if(compressedSize > compressedCapacity) {
        free(compressed);
        compressed = malloc(compressedSize);
        compressedCapacity = compressedSize;
    }
    if(uncompressedSize > uncompressedCapacity) {
        free(uncompressed);
        uncompressed = malloc(uncompressedSize);
        uncompressedCapacity = uncompressedSize;
    }

    fread(compressed, compressedSize, 1, handle);
    printf("decompress %d %d %d %d\n", compressedSize, compressedCapacity, uncompressedSize, uncompressedCapacity); fflush(stdout);
    fastlz_decompress(compressed, compressedSize, uncompressed, uncompressedSize); 
    position = 0;
}

void read(char* data, int offset, int length) {
    int s;

    while(length > uncompressedSize - position) {
        s = uncompressedSize - position;
        memcpy(data + offset, uncompressed + position, s);
        offset += s;
        length -= s;
        fillBuffer();
    }
    memcpy(data + offset, uncompressed + position, length);
    position += length;
}


