/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class ExportUIQueries {
    public static ResourceRead<Collection<Resource>> activeModels(Resource project) {
        return new ActiveModels(project);
    }

    public static Read<List<String>> models(final String project) {
        return new UniqueRead<List<String>>(){

            public List<String> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                ArrayList<String> result = new ArrayList<String>();
                Resource projectRes = graph.getResource(project);
                for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType(projectRes, L0.ConsistsOf, SIMU.Model))) {
                    try {
                        String uri = graph.getURI(model);
                        if (uri == null) continue;
                        result.add(uri);
                    }
                    catch (AssumptionException e) {
                        e.printStackTrace();
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        };
    }
}

