/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.ui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.forms.DataboardForm;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ContentType;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.ExportManager;
import org.simantics.export.core.manager.ExportPlan;
import org.simantics.export.core.manager.ExportWizardResult;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.export.ui.Messages;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.ToStringComparator;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class OptionsPage
extends WizardPage {
    public static String S_OUTPUT_OPTIONS = Messages.OptionsPage_OutputOptions;
    public static LabelReference P_OUTPUT_OPTIONS = new LabelReference(S_OUTPUT_OPTIONS);
    public static String S_PUBLISH = Messages.OptionsPage_PublishTo;
    public static ChildReference P_PUBLISH = ChildReference.compile((ChildReference[])new ChildReference[]{P_OUTPUT_OPTIONS, new LabelReference(S_PUBLISH)});
    ExportContext ctx;
    ScrolledComposite scroll;
    Composite composite;
    DataboardForm form;
    List<Content> selection;
    int selectionHash;
    String selectedPublisherId;
    Listener modificationListener = new Listener(){

        public void handleEvent(Event event) {
            if (OptionsPage.this.updatingForm) {
                return;
            }
            OptionsPage.this.validate();
        }
    };
    boolean updatingForm;
    Listener outputSettingsModifiedListener = new Listener(){

        /*
         * Exception decompiling
         */
        public void handleEvent(Event event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    public OptionsPage(ExportContext ctx) throws ExportException {
        super(Messages.OptionsPage_OptionsPage, Messages.OptionsPage_SelectExportOptions, null);
        this.ctx = ctx;
    }

    public void createControl(Composite parent) {
        this.scroll = new ScrolledComposite(parent, 512);
        this.composite = new Composite((Composite)this.scroll, 0);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.scroll.setContent((Control)this.composite);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(false);
        this.scroll.getVerticalBar().setIncrement(this.scroll.getVerticalBar().getIncrement() * 8);
        this.form = new DataboardForm();
        this.form.setFirstColumnWidth(200);
        this.composite.pack();
        this.setControl((Control)this.scroll);
        this.setPageComplete(true);
    }

    public void update(List<Content> contents) {
        try {
            Content content5;
            Object format;
            TreeSet<String> contentUris = new TreeSet<String>();
            MapList uriToContentMap = new MapList();
            MapList contentByContentType = new MapList();
            MapList contentByFormat = new MapList();
            ArrayList formats = new ArrayList();
            TreeMap<String, Object> contentFormatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            for (Content content2 : contents) {
                contentUris.add(content2.url);
                ContentType ct = this.ctx.eep.getContentType(content2.contentTypeId);
                contentByContentType.add((Object)ct, (Object)content2.url);
                format = this.ctx.eep.getFormat(content2.formatId);
                contentByFormat.add(format, (Object)content2.url);
                uriToContentMap.add((Object)content2.url, (Object)content2);
            }
            formats.addAll(contentByFormat.getKeys());
            Collections.sort(formats, new ToStringComparator());
            for (Content content2 : contents) {
                String id = content2.formatId;
                format = (Format)contentFormatMap.get(id);
                if (format != null) continue;
                format = this.ctx.eep.getFormat(id);
                contentFormatMap.put(id, format);
            }
            MapList exporterContentMap = new MapList();
            TreeMap<CallSite, Exporter> orderedExporters = new TreeMap<CallSite, Exporter>(String.CASE_INSENSITIVE_ORDER);
            for (Content content3 : contents) {
                Exporter[] exporterArray = this.ctx.eep.getExporters(content3.formatId, content3.contentTypeId);
                int n = exporterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Exporter exporter = exporterArray[n2];
                    exporterContentMap.add((Object)exporter, (Object)content3.url);
                    orderedExporters.put((CallSite)((Object)(exporter.formatId() + exporter.contentTypeId() + String.valueOf(exporter.exportAction().getClass()))), exporter);
                    ++n2;
                }
            }
            this.savePrefs();
            this.form.clear((Control)this.composite);
            RecordType optionsRecord = new RecordType();
            RecordType outputOptions = new RecordType();
            for (Format format2 : formats) {
                if (format2.isGroupFormat() && contentByFormat.getValues((Object)format2).size() > 1) {
                    outputOptions.addComponent(NLS.bind((String)Messages.OptionsPage_Merge, (Object)format2.fileext()), (Datatype)Datatypes.BOOLEAN);
                }
                if (!format2.isContainerFormat()) continue;
                List formatsContentUris = contentByFormat.getValues((Object)format2);
                int attachmentCount = 0;
                for (String contentUri : formatsContentUris) {
                    for (Content content4 : uriToContentMap.getValues((Object)contentUri)) {
                        if (content4.formatId.equals(format2.id())) continue;
                        ++attachmentCount;
                    }
                }
                for (Content content5 : contents) {
                    if (this.ctx.eep.getExporters(format2.id(), content5.contentTypeId).length != 0) continue;
                    ++attachmentCount;
                }
                if (attachmentCount <= 0) continue;
                outputOptions.addComponent(NLS.bind((String)Messages.OptionsPage_IncludeAttachmentTo, (Object)format2.fileext()), (Datatype)Datatypes.BOOLEAN);
                outputOptions.addComponent(NLS.bind((String)Messages.OptionsPage_ExportAttachmentOf, (Object)format2.fileext()), (Datatype)Datatypes.BOOLEAN);
            }
            UnionType publisherType = new UnionType();
            content5 = this.ctx.eep.publishers();
            int attachmentCount = ((Publisher[])content5).length;
            int formatsContentUris = 0;
            while (formatsContentUris < attachmentCount) {
                Publisher publisher = content5[formatsContentUris];
                publisherType.addComponent(publisher.label(), Datatypes.VOID);
                ++formatsContentUris;
            }
            outputOptions.addComponent(S_PUBLISH, (Datatype)publisherType);
            optionsRecord.addComponent(S_OUTPUT_OPTIONS, (Datatype)outputOptions);
            for (Format format3 : contentFormatMap.values()) {
                RecordType formatOptions = format3.formatActions().options(this.ctx);
                if (formatOptions == null) continue;
                optionsRecord.mergeRecord(formatOptions);
            }
            for (Exporter exporter : orderedExporters.values()) {
                RecordType exporterOptions;
                List exportSpecificContents = exporterContentMap.getValues((Object)exporter);
                if (exportSpecificContents == null || exportSpecificContents.isEmpty() || (exporterOptions = exporter.exportAction().options(this.ctx, (Collection)exportSpecificContents)) == null) continue;
                optionsRecord.mergeRecord(exporterOptions);
            }
            this.ctx.databoard.clear();
            RecordBinding optionsBinding = (RecordBinding)this.ctx.databoard.getMutableBinding((Datatype)optionsRecord);
            Object optionsObj = optionsBinding.createDefaultUnchecked();
            Variant options = new Variant((Binding)optionsBinding, optionsObj);
            Preferences workspaceScopePrefs = this.ctx.store;
            Preferences contentScopePrefs = this.ctx.store(contents);
            for (Exporter exporter : orderedExporters.values()) {
                exporter.exportAction().fillDefaultPrefs(this.ctx, options);
                exporter.exportAction().loadPref(options, contentScopePrefs, workspaceScopePrefs);
            }
            for (Format format4 : contentByFormat.getKeys()) {
                format4.formatActions().fillDefaultPrefs(this.ctx, options);
                format4.formatActions().loadPref(options, contentScopePrefs, workspaceScopePrefs);
            }
            this.fillDefaultPrefs(options);
            this.loadPref(options, contentScopePrefs, workspaceScopePrefs);
            this.form.addFields(this.composite, optionsRecord);
            this.form.addListener(this.composite, this.form.type(), this.modificationListener);
            Composite outputOptionsGroup = (Composite)this.form.getControl((Control)this.composite, (ChildReference)P_OUTPUT_OPTIONS);
            RecordType dummy = new RecordType();
            dummy.addComponent(S_OUTPUT_OPTIONS, (Datatype)outputOptions);
            this.form.addListener(outputOptionsGroup, dummy, this.outputSettingsModifiedListener);
            this.form.writeFields(this.composite, optionsBinding, optionsObj);
            this.selection = contents;
            Preferences workspaceScopePrefs2 = this.ctx.store;
            Preferences contentScopePrefs2 = this.ctx.store.node("Selection-" + this.selectionHash);
            this.selectedPublisherId = this.ctx.store.get("publisherId", "");
            Publisher publisher = this.ctx.eep.getPublisher(this.selectedPublisherId);
            if (publisher != null) {
                List<Content> manifest = this.getManifestFor(contents, options);
                String label = publisher.label();
                RecordType publisherOptionsType = publisher.publisherClass().locationOptions(this.ctx, manifest);
                RecordType publisherOptionsRootType = new RecordType();
                publisherOptionsRootType.addComponent(label, (Datatype)publisherOptionsType);
                RecordBinding publisherOptionsRootBinding = (RecordBinding)this.ctx.databoard.getMutableBinding((Datatype)publisherOptionsRootType);
                Object publisherOptionsRootObj = publisherOptionsRootBinding.createDefaultUnchecked();
                Variant publisherOptionsRoot = new Variant((Binding)publisherOptionsRootBinding, publisherOptionsRootObj);
                try {
                    LabelReference locationOptionsRef = new LabelReference(label);
                    Variant locationOptions = publisherOptionsRoot.getComponent((ChildReference)locationOptionsRef);
                    publisher.publisherClass().fillDefaultPrefs(this.ctx, this.selection, options, locationOptions);
                    publisher.publisherClass().loadPref(locationOptions, contentScopePrefs2, workspaceScopePrefs2);
                }
                catch (AccessorConstructionException accessorConstructionException) {}
                this.addPublisherToGroup(this.selectedPublisherId, manifest);
                this.form.writeFields(this.composite, publisherOptionsRootBinding, publisherOptionsRootObj);
            }
            this.composite.pack();
            this.validate();
        }
        catch (BindingException e) {
            ExceptionUtils.logError((Throwable)e);
            ShowMessage.showError((String)Messages.OptionsPage_UnExpectedError, (String)(((Object)((Object)e)).getClass().getName() + " " + e.getMessage()));
            throw new RuntimeBindingException(e);
        }
        catch (ExportException e) {
            ExceptionUtils.logError((Throwable)e);
            ShowMessage.showError((String)Messages.OptionsPage_UnExpectedError, (String)(((Object)((Object)e)).getClass().getName() + " " + e.getMessage()));
        }
        catch (DatatypeConstructionException e) {
            ExceptionUtils.logError((Throwable)e);
            ShowMessage.showError((String)Messages.OptionsPage_UnExpectedError, (String)(((Object)((Object)e)).getClass().getName() + " " + e.getMessage()));
        }
        catch (AccessorConstructionException e) {
            ExceptionUtils.logError((Throwable)e);
            ShowMessage.showError((String)Messages.OptionsPage_UnExpectedError, (String)(((Object)((Object)e)).getClass().getName() + " " + e.getMessage()));
        }
        catch (AccessorException e) {
            ExceptionUtils.logError((Throwable)e);
            e.printStackTrace();
        }
    }

    void savePublisherPref(String publisherId, Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            Publisher publisher = this.ctx.eep.getPublisher(publisherId);
            if (publisher == null) {
                return;
            }
            Variant locationOptions = options.getComponent((ChildReference)new LabelReference(publisher.label()));
            publisher.publisherClass().savePref(locationOptions, contentScopePrefs, workspaceScopePrefs);
        }
        catch (AccessorConstructionException e) {
            ExceptionUtils.logError((Throwable)e);
        }
    }

    void loadPublisherPref(String publisherId, Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            Publisher publisher = this.ctx.eep.getPublisher(publisherId);
            if (publisher == null) {
                return;
            }
            Variant locationOptions = options.getComponent((ChildReference)new LabelReference(publisher.label()));
            publisher.publisherClass().fillDefaultPrefs(this.ctx, this.selection, options, locationOptions);
            publisher.publisherClass().loadPref(locationOptions, contentScopePrefs, workspaceScopePrefs);
        }
        catch (AccessorConstructionException e) {
            ExceptionUtils.logError((Throwable)e);
        }
    }

    void cleanPublisherFromGroup(String oldPublisherId) {
        Publisher publisher = this.ctx.eep.getPublisher(oldPublisherId);
        if (publisher != null) {
            String fieldName = publisher.label();
            if (this.form.type().hasComponent(fieldName)) {
                this.form.type().removeComponent(fieldName);
                this.ctx.databoard.clear();
            }
        }
        Combo publishTo = (Combo)this.form.getControl((Control)this.composite, P_PUBLISH);
        Composite group = publishTo.getParent();
        Object[] children = group.getChildren();
        int index = Arrays.indexOf((Object[])children, (Object)publishTo);
        int i = children.length - 1;
        while (i > index) {
            children[i].dispose();
            --i;
        }
    }

    void addPublisherToGroup(String publisherId, List<Content> contents) throws ExportException {
        try {
            Composite group = (Composite)this.form.getControl((Control)this.composite, (ChildReference)P_OUTPUT_OPTIONS);
            if (group == null) {
                return;
            }
            Publisher publisher = this.ctx.eep.getPublisher(publisherId);
            if (publisher == null) {
                return;
            }
            RecordType publisherOptions = publisher.publisherClass().locationOptions(this.ctx, contents);
            RecordType options = new RecordType();
            options.addComponent(publisher.label(), (Datatype)publisherOptions);
            this.form.addFields(group, publisherOptions, publisher.label());
            this.form.addListener(group, options, this.modificationListener);
            this.ctx.databoard.clear();
        }
        catch (BindingException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    List<Content> getManifestFor(List<Content> selection, Variant options) {
        try {
            ExportWizardResult result = new ExportWizardResult();
            result.options = options;
            result.accessor = (RecordAccessor)Accessors.getAccessor((Variant)result.options);
            result.contents = selection;
            result.type = (RecordType)options.type();
            result.publisherId = "file";
            ArrayList actions = new ArrayList();
            ArrayList<Content> manifest = new ArrayList<Content>();
            result.createExportActions(this.ctx, actions, manifest);
            return manifest;
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return selection;
        }
        catch (ExportException e) {
            e.printStackTrace();
            return selection;
        }
    }

    public ExportWizardResult getOutput() throws ExportException {
        ExportWizardResult result = new ExportWizardResult();
        try {
            this.ctx.databoard.clear();
            result.type = this.form.type();
            RecordBinding binding = (RecordBinding)this.ctx.databoard.getMutableBinding((Datatype)result.type);
            Object optionsObj = binding.createDefault();
            result.options = new Variant((Binding)binding, optionsObj);
            this.form.readFields(this.composite, binding, optionsObj);
            result.accessor = (RecordAccessor)Accessors.getAccessor((Variant)result.options);
            result.contents = this.selection;
            String publisherLabel = ExporterUtils.getUnionValue((Accessor)result.accessor, (ChildReference)P_PUBLISH);
            Publisher publisher = this.ctx.eep.getPublisherByLabel(publisherLabel);
            result.publisherId = publisher == null ? "" : publisher.id();
        }
        catch (BindingException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        return result;
    }

    void validate() {
        List problems = this.form.validate(this.composite);
        List errs = DataboardForm.toStrings((List)problems);
        if (errs.isEmpty()) {
            try {
                ExportWizardResult result = this.getOutput();
                ExportPlan plan = new ExportPlan();
                result.createPlan(this.ctx, plan);
                ExportManager mgr = new ExportManager(result.options, this.ctx);
                errs.addAll(mgr.validate(this.ctx, plan));
            }
            catch (ExportException e) {
                errs.add(e.getMessage());
            }
        } else {
            CollectionUtils.unique((List)errs);
        }
        this.setErrorMessage(errs.isEmpty() ? null : CollectionUtils.toString((Collection)errs, (String)", "));
        this.setPageComplete(errs.isEmpty());
    }

    void savePref(Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String publisherId = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_PUBLISH);
            Publisher publisher = this.ctx.eep.getPublisherByLabel(publisherId);
            if (publisher != null) {
                workspaceScopePrefs.put("publisherId", publisher.id());
            }
            if (ra.type().hasComponent(OptionsPage.P_OUTPUT_OPTIONS.label)) {
                RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
                Pattern merge_pattern = Pattern.compile("Merge ([^\\s]*) content into one file");
                Pattern include_pattern = Pattern.compile("Include attachments to ([^\\s]*)");
                Pattern export_pattern = Pattern.compile("Export attachments of ([^\\s]*) to separate files");
                int i = 0;
                while (i < rao.count()) {
                    String key;
                    Boolean value;
                    Format format;
                    String fileExt;
                    String name = rao.type().getComponent((int)i).name;
                    Matcher m = merge_pattern.matcher(name);
                    if (m.matches()) {
                        fileExt = m.group(1);
                        format = this.ctx.eep.getFormatByExt(fileExt);
                        value = (Boolean)rao.getFieldValue(i, (Binding)Bindings.BOOLEAN);
                        key = format.id() + "_merge";
                        contentScopePrefs.putBoolean(key, value.booleanValue());
                        workspaceScopePrefs.putBoolean(key, value.booleanValue());
                    }
                    if ((m = include_pattern.matcher(name)).matches()) {
                        fileExt = m.group(1);
                        format = this.ctx.eep.getFormatByExt(fileExt);
                        value = (Boolean)rao.getFieldValue(i, (Binding)Bindings.BOOLEAN);
                        key = format.id() + "_include_attachments";
                        contentScopePrefs.putBoolean(key, value.booleanValue());
                        workspaceScopePrefs.putBoolean(key, value.booleanValue());
                    }
                    if ((m = export_pattern.matcher(name)).matches()) {
                        fileExt = m.group(1);
                        format = this.ctx.eep.getFormatByExt(fileExt);
                        value = (Boolean)rao.getFieldValue(i, (Binding)Bindings.BOOLEAN);
                        key = format.id() + "_export_attachments";
                        contentScopePrefs.putBoolean(key, value.booleanValue());
                        workspaceScopePrefs.putBoolean(key, value.booleanValue());
                    }
                    ++i;
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    void loadPref(Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String publisherId = workspaceScopePrefs.get("publisherId", "");
            Publisher publisher = this.ctx.eep.getPublisher(publisherId);
            if (publisher != null) {
                ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_PUBLISH, (String)publisher.label());
            }
            if (ra.type().hasComponent(OptionsPage.P_OUTPUT_OPTIONS.label)) {
                RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
                Format[] formatArray = this.ctx.eep.formats();
                int n = formatArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index;
                    String key2;
                    Boolean value;
                    String key;
                    Format format = formatArray[n2];
                    if (format.isGroupFormat()) {
                        key = format.id() + "_merge";
                        value = null;
                        if (OptionsPage.containsKey(contentScopePrefs, key)) {
                            value = contentScopePrefs.getBoolean(key, false);
                        } else if (OptionsPage.containsKey(workspaceScopePrefs, key)) {
                            value = workspaceScopePrefs.getBoolean(key, false);
                        }
                        if (value != null) {
                            key2 = "Merge " + format.fileext() + " content into one file";
                            index = rao.type().getComponentIndex2(key2);
                            if (index >= 0) {
                                rao.setFieldValue(index, (Binding)Bindings.BOOLEAN, (Object)value);
                            }
                        }
                    }
                    if (format.isContainerFormat()) {
                        key = format.id() + "_include_attachments";
                        value = null;
                        if (OptionsPage.containsKey(contentScopePrefs, key)) {
                            value = contentScopePrefs.getBoolean(key, false);
                        } else if (OptionsPage.containsKey(workspaceScopePrefs, key)) {
                            value = workspaceScopePrefs.getBoolean(key, false);
                        }
                        if (value != null) {
                            key2 = "Include attachments to " + format.fileext();
                            index = rao.type().getComponentIndex2(key2);
                            if (index >= 0) {
                                rao.setFieldValue(index, (Binding)Bindings.BOOLEAN, (Object)value);
                            }
                        }
                    }
                    if (format.isContainerFormat()) {
                        key = format.id() + "_export_attachments";
                        value = null;
                        if (OptionsPage.containsKey(contentScopePrefs, key)) {
                            value = contentScopePrefs.getBoolean(key, false);
                        } else if (OptionsPage.containsKey(workspaceScopePrefs, key)) {
                            value = workspaceScopePrefs.getBoolean(key, false);
                        }
                        if (value != null) {
                            key2 = "Export attachments of" + format.fileext() + " to separate files";
                            index = rao.type().getComponentIndex2(key2);
                            if (index >= 0) {
                                rao.setFieldValue(index, (Binding)Bindings.BOOLEAN, (Object)value);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void savePrefs() throws ExportException {
        try {
            Publisher publisher;
            String publisherLabel;
            int oldSelectionHash = this.selectionHash;
            Preferences contentScopePrefs = this.ctx.store.node("Selection-" + oldSelectionHash);
            Preferences workspaceScopePrefs = this.ctx.store;
            RecordBinding binding = (RecordBinding)this.ctx.databoard.getMutableBinding((Datatype)this.form.type());
            Object obj = binding.createDefault();
            Variant options = new Variant((Binding)binding, obj);
            this.form.readFields(this.composite, binding, obj);
            Combo publishTo = (Combo)this.form.getControl((Control)this.composite, P_PUBLISH);
            String string = publisherLabel = publishTo == null ? null : publishTo.getText();
            if (publisherLabel != null && (publisher = this.ctx.eep.getPublisherByLabel(publisherLabel)) != null) {
                try {
                    LabelReference locationOptionsRef = new LabelReference(publisher.label());
                    Variant locationOptions = options.getComponent((ChildReference)locationOptionsRef);
                    publisher.publisherClass().savePref(locationOptions, contentScopePrefs, workspaceScopePrefs);
                }
                catch (AccessorConstructionException accessorConstructionException) {}
            }
            Exporter[] exporterArray = this.ctx.eep.exporters();
            int n = exporterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Exporter exporter = exporterArray[n2];
                exporter.exportAction().savePref(options, contentScopePrefs, workspaceScopePrefs);
                ++n2;
            }
            exporterArray = this.ctx.eep.formats();
            n = exporterArray.length;
            n2 = 0;
            while (n2 < n) {
                Exporter format = exporterArray[n2];
                format.formatActions().savePref(options, contentScopePrefs, workspaceScopePrefs);
                ++n2;
            }
            this.savePref(options, contentScopePrefs, workspaceScopePrefs);
        }
        catch (BindingException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
        catch (ExportException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void fillDefaultPrefs(Variant options) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            if (ra.type().hasComponent(OptionsPage.P_OUTPUT_OPTIONS.label)) {
                RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
                Format[] formatArray = this.ctx.eep.formats();
                int n = formatArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Format format = formatArray[n2];
                    if (format.isContainerFormat()) {
                        String key = "Include attachments to " + format.fileext();
                        int index = rao.type().getComponentIndex2(key);
                        if (index >= 0) {
                            rao.setFieldValue(index, (Binding)Bindings.BOOLEAN, (Object)true);
                        }
                        key = "Export attachments of " + format.fileext() + " to separate files";
                        index = rao.type().getComponentIndex2(key);
                        if (index >= 0) {
                            rao.setFieldValue(index, (Binding)Bindings.BOOLEAN, (Object)true);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean containsKey(Preferences pref, String key) {
        try {
            String[] stringArray = pref.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String x = stringArray[n2];
                if (x.equals(key)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return false;
    }
}

