/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PageNumbering {
    private static int pageNumberAlignment(Position positioning) {
        switch (positioning) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                return 0;
            }
        }
        return 2;
    }

    private static Point2D.Float pageNumberPosition(Position positioning, Rectangle pageSize, Font font) {
        switch (positioning) {
            case TOP_LEFT: {
                return new Point2D.Float(12.0f, pageSize.getHeight() - 12.0f - font.getCalculatedSize() * 0.8f);
            }
            case TOP_RIGHT: {
                return new Point2D.Float(pageSize.getWidth() - 12.0f, pageSize.getHeight() - 12.0f - font.getCalculatedSize() * 0.8f);
            }
            case BOTTOM_LEFT: {
                return new Point2D.Float(12.0f, 12.0f);
            }
        }
        return new Point2D.Float(pageSize.getWidth() - 12.0f, 12.0f);
    }

    public static String formatPageNumber(NumberingFormat format, int pageNumber, int totalPages) {
        switch (format) {
            case PAGE_SLASH_TOTAL_PAGES: {
                return String.format("%d / %d", pageNumber, totalPages);
            }
        }
        throw new UnsupportedOperationException("Unsupported numbering format: " + String.valueOf((Object)format));
    }

    public static void addPageNumber(PdfCopy pdfCopy, PdfReader sourceReader, int sourcePageNumber, int currentPageNumber, int totalPages, Font font, Position positioning, NumberingFormat format) throws IOException, BadPdfFormatException {
        Rectangle pageSize = sourceReader.getPageSizeWithRotation(sourcePageNumber);
        PdfImportedPage imp = pdfCopy.getImportedPage(sourceReader, sourcePageNumber);
        PdfCopy.PageStamp ps = pdfCopy.createPageStamp(imp);
        PdfContentByte over = ps.getOverContent();
        String text = PageNumbering.formatPageNumber(format, currentPageNumber, totalPages);
        Point2D.Float pos = PageNumbering.pageNumberPosition(positioning, pageSize, font);
        int alignment = PageNumbering.pageNumberAlignment(positioning);
        ColumnText.showTextAligned((PdfContentByte)over, (int)alignment, (Phrase)new Phrase(text, font), (float)pos.x, (float)pos.y, (float)0.0f);
        ps.alterContents();
        pdfCopy.addPage(imp);
    }

    public static void addPageNumbers(IProgressMonitor monitor, Path inputFile, Path outputFile, Position positioning, NumberingFormat format, Font pageNumberFont) throws IOException, DocumentException {
        try (PdfReader reader = null;){
            reader = new PdfReader(inputFile.toString());
            int totalPages = reader.getNumberOfPages();
            int currentPage = 1;
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)totalPages);
            Throwable throwable = null;
            Object var11_12 = null;
            try (OutputStream fos = Files.newOutputStream(outputFile, new OpenOption[0]);){
                Document document = new Document();
                PdfCopy pdfCopy = new PdfCopy(document, fos);
                pdfCopy.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
                document.open();
                try {
                    int i = 1;
                    while (i <= totalPages) {
                        mon.subTask(i + "/" + totalPages);
                        PageNumbering.addPageNumber(pdfCopy, reader, i, currentPage++, totalPages, pageNumberFont, positioning, format);
                        ++i;
                    }
                }
                finally {
                    if (document != null && document.isOpen()) {
                        document.close();
                    }
                    if (pdfCopy != null) {
                        pdfCopy.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void addPageNumbers(IProgressMonitor monitor, Path inputFile, Path outputFile, Position positioning, NumberingFormat format) throws IOException, DocumentException {
        PageNumbering.addPageNumbers(monitor, inputFile, outputFile, positioning, format, new Font(1, 8.0f));
    }

    public static enum NumberingFormat {
        PAGE_SLASH_TOTAL_PAGES;

    }

    public static enum Position {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

