/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.forms.DataboardForm;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.PublisherClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.utils.FileUtils;

public class DirPublisher
implements PublisherClass {
    public static RecordType RT_DIR;
    public static LabelReference P_ALLOW_OVERWRITE;
    public static LabelReference P_EXPORT_LOCATION;

    static {
        P_ALLOW_OVERWRITE = new LabelReference("Overwrite file(s)");
        P_EXPORT_LOCATION = new LabelReference("Export location");
        RT_DIR = new RecordType();
        RT_DIR.addComponent(DirPublisher.P_EXPORT_LOCATION.label, (Datatype)DataboardForm.directoryDialog());
        RT_DIR.addComponent(DirPublisher.P_ALLOW_OVERWRITE.label, (Datatype)Datatypes.BOOLEAN);
    }

    @Override
    public void publish(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions, IProgressMonitor monitor) throws ExportException {
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        String path = ExporterUtils.getString(locationOptions, (ChildReference)P_EXPORT_LOCATION);
        if (path == null) {
            throw new ExportException("Path option missing");
        }
        if (canOverwrite == null) {
            throw new ExportException("CanOverwrite option missing");
        }
        for (Content content : contents) {
            if (content.tmpFile == null) {
                throw new ExportException("Internal error, tmpFile was null");
            }
            File file = new File(path, content.filename);
            if (file.exists()) {
                if (canOverwrite.booleanValue()) {
                    file.delete();
                } else {
                    throw new ExportException("Would not overwrite " + file.getAbsolutePath());
                }
            }
            if (!content.tmpFile.exists()) {
                throw new ExportException("temporary file " + content.tmpFile.getAbsolutePath() + " did not exist?");
            }
            if (!content.tmpFile.renameTo(file)) {
                try {
                    FileUtils.copyFile((File)content.tmpFile, (File)file);
                    if (!content.tmpFile.delete()) {
                        throw new IOException("Failed to delete " + content.tmpFile.getAbsolutePath() + " after copying it");
                    }
                }
                catch (IOException e) {
                    throw new ExportException("Failed to move temporary file " + content.tmpFile.getAbsolutePath() + " to " + file.getAbsolutePath(), e);
                }
            }
            if (!content.tmpFile.exists()) continue;
            throw new ExportException("Failed to move temporary file " + content.tmpFile.getAbsolutePath() + " to " + file.getAbsolutePath());
        }
    }

    @Override
    public List<String> validate(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        ArrayList<String> result = new ArrayList<String>();
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        String pathName = ExporterUtils.getString(locationOptions, (ChildReference)P_EXPORT_LOCATION);
        if (pathName == null) {
            result.add("Location option missing?");
            return result;
        }
        if (canOverwrite == null) {
            result.add("CanOverwrite option missing?");
            return result;
        }
        if (pathName.isEmpty()) {
            result.add("Location must be entered.");
            return result;
        }
        File path = new File(pathName);
        if (path.exists() && !path.isDirectory()) {
            result.add(pathName + " is not a directory.");
        }
        if (!canOverwrite.booleanValue() && path.exists()) {
            for (Content content : contents) {
                File file = new File(path, content.filename);
                if (!file.exists()) continue;
                result.add(file.getAbsolutePath() + " already exists.");
            }
        }
        return result;
    }

    @Override
    public RecordType locationOptions(ExportContext ctx, List<Content> contents) throws ExportException {
        return RT_DIR;
    }

    @Override
    public Variant createLocation(ExportContext ctx, Variant locationOptions) throws ExportException {
        String pathName = ExporterUtils.getString(locationOptions, (ChildReference)P_EXPORT_LOCATION);
        if (pathName == null) {
            throw new ExportException("Location option not found?");
        }
        File path = new File(pathName);
        if (path.exists() && !path.isDirectory()) {
            throw new ExportException(pathName + " exists but is not a directory.");
        }
        if (!path.mkdirs()) {
            throw new ExportException("Failed to create " + pathName);
        }
        return locationOptions;
    }

    @Override
    public boolean locationExists(ExportContext ctx, Variant locationOptions) throws ExportException {
        String location;
        block4: {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            location = (String)ra.getValue((ChildReference)P_EXPORT_LOCATION, (Binding)Bindings.STRING);
            if (location != null) break block4;
            return false;
        }
        try {
            File path = new File(location);
            return path.exists() && path.isDirectory();
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void fillDefaultPrefs(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)true);
            ra.setValue((ChildReference)P_EXPORT_LOCATION, (Binding)Bindings.STRING, (Object)"");
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void savePref(Variant locationOptions, Preferences contentScopeNode, Preferences workspaceScopeNode) throws ExportException {
        try {
            String s;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            Boolean b = (Boolean)ra.getValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN);
            if (b != null) {
                contentScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
                workspaceScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
            }
            if ((s = (String)ra.getValue((ChildReference)P_EXPORT_LOCATION, (Binding)Bindings.STRING)) != null) {
                contentScopeNode.put(P_EXPORT_LOCATION.tail().toString(), s);
                workspaceScopeNode.put(P_EXPORT_LOCATION.tail().toString(), s);
            }
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void loadPref(Variant locationOptions, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            String s;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            Boolean b = ExporterUtils.getPrefBoolean(contentScopePrefs, workspaceScopePrefs, P_ALLOW_OVERWRITE.tail().toString());
            if (b != null) {
                ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)b);
            }
            if ((s = ExporterUtils.getPrefString(contentScopePrefs, workspaceScopePrefs, P_EXPORT_LOCATION.tail().toString())) != null) {
                ra.setValue((ChildReference)P_EXPORT_LOCATION, (Binding)Bindings.STRING, (Object)s);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }
}

