package org.simantics.export.core;

import org.simantics.export.core.intf.ContentType;
import org.simantics.export.core.intf.Discoverer;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.Importer;
import org.simantics.export.core.intf.Publisher;

/**
 * Export Extension Point services
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface ExportExtensionPoint {

	ContentType[] contentTypes();
	Discoverer[] discoverers();
	Format[] formats();
	Importer[] importers();
	Exporter[] exporters();	
	Publisher[] publishers();
	
	Discoverer[] getDiscoverers(String contentTypeId);
	Format getFormat(String formatId);
	Format getFormatByExt(String fileExt);
	ContentType getContentType(String contentTypeId);
	Importer getImporter(String formatId);
	Exporter[] getExporters(String formatId, String contentTypeId);
	Publisher getPublisher(String publisherId);
	Publisher getPublisherByLabel(String publisherLabel);
	int getPublisherIndex(String publisherId);
	
	/**
	 * Get exporters for a content type. The result is priority ordered list.
	 *  
	 * @param contentTypeId
	 * @return ordered list of exporters
	 */
	Exporter[] getExportersForContentType(String contentTypeId);
	
	/**
	 * Get exporters for a content type. The result is priority ordered list.
	 *  
	 * @param formatId
	 * @return ordered list of exporters
	 */
	Exporter[] getExportersForFormat(String formatId);
	
	
}
