/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.Constants;

/**
 * @author Tuukka Lehtonen
 */
public enum EventDecorationRule implements LabelDecorationRule {

    INSTANCE;

    public static EventDecorationRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource event = (Resource) content;

        EventResource EVENT = EventResource.getInstance(graph);

        final boolean milestone = graph.hasStatement(event, EVENT.Milestone);
        final boolean hidden = graph.hasStatement(event, EVENT.Hidden);
        final boolean baseline = graph.hasStatement(event, EVENT.EventLog_HasBaselineEvent_Inverse);
        final boolean returnEvent = graph.hasStatement(event, EVENT.ReturnEvent);
        final boolean returnedEvent = graph.hasStatement(event, EVENT.ReturnedBy);
        if (!milestone && !hidden && !baseline && !returnEvent && !returnedEvent)
            return null;

        return new LabelDecorator.Stub() {
            @SuppressWarnings("unchecked")
            @Override
            public <F> F decorateFont(F font, String column, int itemIndex) {
                int style = 0;
                style |= milestone ? SWT.BOLD : 0;
                style |= hidden ? SWT.ITALIC : 0;
                return style != 0 ? (F) ((FontDescriptor) font).setStyle(style) : font;
            }
            @SuppressWarnings("unchecked")
            @Override
            public <C> C decorateForeground(C color, String column, int itemIndex) {
                if (returnEvent || returnedEvent)
                    return (C) Constants.RETURN_EVENT_FG;
                return color;
            }
            @Override
            public <C> C decorateBackground(C color, String column, int itemIndex) {
                return color;
            }
        };
    }

}
