/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.event.ontology.EventResource;

/**
 * @author Tuukka Lehtonen
 */
public class Constants {

    public static final int             EVENT_SEVERITY_STEP      = 100;

    public static final int             EVENT_SEVERITY_INFO      = 600;
    public static final int             EVENT_SEVERITY_WARNING   = 700;
    public static final int             EVENT_SEVERITY_ERROR     = 1000;
    public static final int             EVENT_SEVERITY_FATAL     = 1200;

    public static final ColorDescriptor RETURN_EVENT_FG          = ColorDescriptor.createFrom(new RGB(160, 160, 160));
    //public static final ColorDescriptor MILESTONE_BG             = ColorDescriptor.createFrom(new RGB(240, 240, 240));
    //public static final ColorDescriptor BASELINE_BG              = ColorDescriptor.createFrom(new RGB(200, 200, 200));

    // Available columns in the events view

    public static final String          COLUMN_TIMESTAMP         = "timestamp";

    /**
     * A hidden data meant for time-wise sorting of events.
     */
    public static final String          COLUMN_TIMESTAMP_NUMERIC = "timestampNumeric";

    public static final String          COLUMN_EVENT_INDEX       = "index";

    /**
     * Thin column, normally empty. If an event is selected as a milestone then
     * this column will show a black milestone diamond icon with numbering. If
     * it is also the baseline, the diamond will be gray.
     */
    public static final String          COLUMN_MILESTONE         = "milestone";

    /**
     * Shows an icon and text describing the event type.
     */
    public static final String          COLUMN_EVENT_TYPE        = "eventType";

    /**
     * Only shows an icon describing whether the state described by the event
     * has been returned or not. Also interpretable as the "completion" of an
     * event.
     * 
     * Events expected to return are marked with an X and returned events with a
     * check mark.
     * 
     * @see EventResource#Returns
     * @see EventResource#ReturnedBy
     * @see EventResource#NoReturn
     */
    public static final String          COLUMN_RETURNED          = "returned";

    /**
     * Tag describing the event.
     */
    public static final String          COLUMN_TAG_NAME          = "tag";

    /**
     * Message contained by the event.
     */
    public static final String          COLUMN_MESSAGE           = "message";

    /**
     * Message contained by the event.
     */
    public static final String          COLUMN_RETURN_TIME       = "returnTime";

    public static final String          COLUMN_RETURN_TIME_NUMERIC = "returnTimeNumeric";

    /**
     * Name of the event source.
     */
    public static final String          COLUMN_SOURCE_NAME       = "sourceName";

    public static final String[]        COLUMN_KEYS              = {
        COLUMN_EVENT_INDEX,
        COLUMN_TIMESTAMP,
        COLUMN_TIMESTAMP_NUMERIC,
        COLUMN_MILESTONE,
        COLUMN_EVENT_TYPE,
        COLUMN_RETURNED,
        COLUMN_TAG_NAME,
        COLUMN_MESSAGE,
        COLUMN_RETURN_TIME,
        COLUMN_RETURN_TIME_NUMERIC,
        COLUMN_SOURCE_NAME
    };

}
