package org.simantics.event.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class EventViewResource {
    
    public final Resource EventBrowseContext;
    public final Resource EventBrowseContext_EventDecorationRule;
    public final Resource EventBrowseContext_EventImageRule;
    public final Resource EventBrowseContext_EventLabelRule;
    public final Resource EventBrowseContext_EventLogImageRule;
    public final Resource EventBrowseContext_EventLogLabelRule;
    public final Resource EventBrowseContext_EventLogsRule;
    public final Resource EventBrowseContext_EventsRule;
    public final Resource EventBrowseContext_ProjectEventsRule;
    public final Resource HideInfoEvents;
    public final Resource HideInfoEvents_Inverse;
    public final Resource HideReturnEvents;
    public final Resource HideReturnEvents_Inverse;
    public final Resource HideWarningEvents;
    public final Resource HideWarningEvents_Inverse;
    public final Resource ManualEventType;
    public final Resource ShowHiddenEvents;
    public final Resource ShowHiddenEvents_Inverse;
    public final Resource ShowOnlyActiveEvents;
    public final Resource ShowOnlyActiveEvents_Inverse;
    public final Resource ShowOnlyMilestones;
    public final Resource ShowOnlyMilestones_Inverse;
        
    public static class URIs {
        public static final String EventBrowseContext = "http://www.simantics.org/Event-1.2/View/EventBrowseContext";
        public static final String EventBrowseContext_EventDecorationRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventDecorationRule";
        public static final String EventBrowseContext_EventImageRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventImageRule";
        public static final String EventBrowseContext_EventLabelRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLabelRule";
        public static final String EventBrowseContext_EventLogImageRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogImageRule";
        public static final String EventBrowseContext_EventLogLabelRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogLabelRule";
        public static final String EventBrowseContext_EventLogsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogsRule";
        public static final String EventBrowseContext_EventsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventsRule";
        public static final String EventBrowseContext_ProjectEventsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/ProjectEventsRule";
        public static final String HideInfoEvents = "http://www.simantics.org/Event-1.2/View/HideInfoEvents";
        public static final String HideInfoEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideInfoEvents/Inverse";
        public static final String HideReturnEvents = "http://www.simantics.org/Event-1.2/View/HideReturnEvents";
        public static final String HideReturnEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideReturnEvents/Inverse";
        public static final String HideWarningEvents = "http://www.simantics.org/Event-1.2/View/HideWarningEvents";
        public static final String HideWarningEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideWarningEvents/Inverse";
        public static final String ManualEventType = "http://www.simantics.org/Event-1.2/View/ManualEventType";
        public static final String ShowHiddenEvents = "http://www.simantics.org/Event-1.2/View/ShowHiddenEvents";
        public static final String ShowHiddenEvents_Inverse = "http://www.simantics.org/Event-1.2/View/ShowHiddenEvents/Inverse";
        public static final String ShowOnlyActiveEvents = "http://www.simantics.org/Event-1.2/View/ShowOnlyActiveEvents";
        public static final String ShowOnlyActiveEvents_Inverse = "http://www.simantics.org/Event-1.2/View/ShowOnlyActiveEvents/Inverse";
        public static final String ShowOnlyMilestones = "http://www.simantics.org/Event-1.2/View/ShowOnlyMilestones";
        public static final String ShowOnlyMilestones_Inverse = "http://www.simantics.org/Event-1.2/View/ShowOnlyMilestones/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public EventViewResource(ReadGraph graph) {
        EventBrowseContext = getResourceOrNull(graph, URIs.EventBrowseContext);
        EventBrowseContext_EventDecorationRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventDecorationRule);
        EventBrowseContext_EventImageRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventImageRule);
        EventBrowseContext_EventLabelRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventLabelRule);
        EventBrowseContext_EventLogImageRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventLogImageRule);
        EventBrowseContext_EventLogLabelRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventLogLabelRule);
        EventBrowseContext_EventLogsRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventLogsRule);
        EventBrowseContext_EventsRule = getResourceOrNull(graph, URIs.EventBrowseContext_EventsRule);
        EventBrowseContext_ProjectEventsRule = getResourceOrNull(graph, URIs.EventBrowseContext_ProjectEventsRule);
        HideInfoEvents = getResourceOrNull(graph, URIs.HideInfoEvents);
        HideInfoEvents_Inverse = getResourceOrNull(graph, URIs.HideInfoEvents_Inverse);
        HideReturnEvents = getResourceOrNull(graph, URIs.HideReturnEvents);
        HideReturnEvents_Inverse = getResourceOrNull(graph, URIs.HideReturnEvents_Inverse);
        HideWarningEvents = getResourceOrNull(graph, URIs.HideWarningEvents);
        HideWarningEvents_Inverse = getResourceOrNull(graph, URIs.HideWarningEvents_Inverse);
        ManualEventType = getResourceOrNull(graph, URIs.ManualEventType);
        ShowHiddenEvents = getResourceOrNull(graph, URIs.ShowHiddenEvents);
        ShowHiddenEvents_Inverse = getResourceOrNull(graph, URIs.ShowHiddenEvents_Inverse);
        ShowOnlyActiveEvents = getResourceOrNull(graph, URIs.ShowOnlyActiveEvents);
        ShowOnlyActiveEvents_Inverse = getResourceOrNull(graph, URIs.ShowOnlyActiveEvents_Inverse);
        ShowOnlyMilestones = getResourceOrNull(graph, URIs.ShowOnlyMilestones);
        ShowOnlyMilestones_Inverse = getResourceOrNull(graph, URIs.ShowOnlyMilestones_Inverse);
    }
    
    public static EventViewResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        EventViewResource ret = session.peekService(EventViewResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new EventViewResource(qc.getIndependentGraph(graph));
            session.registerService(EventViewResource.class, ret);
        }
        return ret;
    }
    
    public static EventViewResource getInstance(RequestProcessor session) throws DatabaseException {
        EventViewResource ret = session.peekService(EventViewResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<EventViewResource>() {
                public EventViewResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new EventViewResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(EventViewResource.class, ret);
        }
        return ret;
    }
    
}

