package org.simantics.event.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class EventResource {
    
    public final Resource Event;
    public final Resource EventLog;
    public final Resource EventLog_HasBaselineEvent;
    public final Resource EventLog_HasBaselineEvent_Inverse;
    public final Resource EventSlice;
    public final Resource EventType;
    public final Resource EventType_severity;
    public final Resource EventType_severity_Inverse;
    public final Resource Event_index;
    public final Resource Event_index_Inverse;
    public final Resource Event_message;
    public final Resource Event_message_Inverse;
    public final Resource Event_milestoneLabel;
    public final Resource Event_milestoneLabel_Inverse;
    public final Resource Event_source;
    public final Resource Event_sourceName;
    public final Resource Event_sourceName_Inverse;
    public final Resource Event_source_inverse;
    public final Resource Event_tag;
    public final Resource Event_tag_Inverse;
    public final Resource Event_type;
    public final Resource Event_typeNumber;
    public final Resource Event_typeNumber_Inverse;
    public final Resource HasEventLog;
    public final Resource HasEventProducer;
    public final Resource HasModificationCounter;
    public final Resource HasModificationCounter_Inverse;
    public final Resource HasTimestamp;
    public final Resource HasTimestamp_Inverse;
    public final Resource Hidden;
    public final Resource IsEventLogOf;
    public final Resource IsEventProducerOf;
    public final Resource Milestone;
    public final Resource NoReturn;
    public final Resource ReturnEvent;
    public final Resource ReturnedBy;
    public final Resource Returns;
    public final Resource TimeStamp;
    public final Resource View;
    public final Resource View_EventBrowseContext;
    public final Resource View_EventBrowseContext_EventDecorationRule;
    public final Resource View_EventBrowseContext_EventImageRule;
    public final Resource View_EventBrowseContext_EventLabelRule;
    public final Resource View_EventBrowseContext_EventLogImageRule;
    public final Resource View_EventBrowseContext_EventLogLabelRule;
    public final Resource View_EventBrowseContext_EventLogsRule;
    public final Resource View_EventBrowseContext_EventsRule;
    public final Resource View_EventBrowseContext_ProjectEventsRule;
    public final Resource View_HideInfoEvents;
    public final Resource View_HideInfoEvents_Inverse;
    public final Resource View_HideReturnEvents;
    public final Resource View_HideReturnEvents_Inverse;
    public final Resource View_HideWarningEvents;
    public final Resource View_HideWarningEvents_Inverse;
    public final Resource View_ManualEventType;
    public final Resource View_ShowHiddenEvents;
    public final Resource View_ShowHiddenEvents_Inverse;
    public final Resource View_ShowOnlyActiveEvents;
    public final Resource View_ShowOnlyActiveEvents_Inverse;
    public final Resource View_ShowOnlyMilestones;
    public final Resource View_ShowOnlyMilestones_Inverse;
        
    public static class URIs {
        public static final String Event = "http://www.simantics.org/Event-1.2/Event";
        public static final String EventLog = "http://www.simantics.org/Event-1.2/EventLog";
        public static final String EventLog_HasBaselineEvent = "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent";
        public static final String EventLog_HasBaselineEvent_Inverse = "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent/Inverse";
        public static final String EventSlice = "http://www.simantics.org/Event-1.2/EventSlice";
        public static final String EventType = "http://www.simantics.org/Event-1.2/EventType";
        public static final String EventType_severity = "http://www.simantics.org/Event-1.2/EventType/severity";
        public static final String EventType_severity_Inverse = "http://www.simantics.org/Event-1.2/EventType/severity/Inverse";
        public static final String Event_index = "http://www.simantics.org/Event-1.2/Event/index";
        public static final String Event_index_Inverse = "http://www.simantics.org/Event-1.2/Event/index/Inverse";
        public static final String Event_message = "http://www.simantics.org/Event-1.2/Event/message";
        public static final String Event_message_Inverse = "http://www.simantics.org/Event-1.2/Event/message/Inverse";
        public static final String Event_milestoneLabel = "http://www.simantics.org/Event-1.2/Event/milestoneLabel";
        public static final String Event_milestoneLabel_Inverse = "http://www.simantics.org/Event-1.2/Event/milestoneLabel/Inverse";
        public static final String Event_source = "http://www.simantics.org/Event-1.2/Event/source";
        public static final String Event_sourceName = "http://www.simantics.org/Event-1.2/Event/sourceName";
        public static final String Event_sourceName_Inverse = "http://www.simantics.org/Event-1.2/Event/sourceName/Inverse";
        public static final String Event_source_inverse = "http://www.simantics.org/Event-1.2/Event/source/inverse";
        public static final String Event_tag = "http://www.simantics.org/Event-1.2/Event/tag";
        public static final String Event_tag_Inverse = "http://www.simantics.org/Event-1.2/Event/tag/Inverse";
        public static final String Event_type = "http://www.simantics.org/Event-1.2/Event/type";
        public static final String Event_typeNumber = "http://www.simantics.org/Event-1.2/Event/typeNumber";
        public static final String Event_typeNumber_Inverse = "http://www.simantics.org/Event-1.2/Event/typeNumber/Inverse";
        public static final String HasEventLog = "http://www.simantics.org/Event-1.2/HasEventLog";
        public static final String HasEventProducer = "http://www.simantics.org/Event-1.2/HasEventProducer";
        public static final String HasModificationCounter = "http://www.simantics.org/Event-1.2/HasModificationCounter";
        public static final String HasModificationCounter_Inverse = "http://www.simantics.org/Event-1.2/HasModificationCounter/Inverse";
        public static final String HasTimestamp = "http://www.simantics.org/Event-1.2/HasTimestamp";
        public static final String HasTimestamp_Inverse = "http://www.simantics.org/Event-1.2/HasTimestamp/Inverse";
        public static final String Hidden = "http://www.simantics.org/Event-1.2/Hidden";
        public static final String IsEventLogOf = "http://www.simantics.org/Event-1.2/IsEventLogOf";
        public static final String IsEventProducerOf = "http://www.simantics.org/Event-1.2/IsEventProducerOf";
        public static final String Milestone = "http://www.simantics.org/Event-1.2/Milestone";
        public static final String NoReturn = "http://www.simantics.org/Event-1.2/NoReturn";
        public static final String ReturnEvent = "http://www.simantics.org/Event-1.2/ReturnEvent";
        public static final String ReturnedBy = "http://www.simantics.org/Event-1.2/ReturnedBy";
        public static final String Returns = "http://www.simantics.org/Event-1.2/Returns";
        public static final String TimeStamp = "http://www.simantics.org/Event-1.2/TimeStamp";
        public static final String View = "http://www.simantics.org/Event-1.2/View";
        public static final String View_EventBrowseContext = "http://www.simantics.org/Event-1.2/View/EventBrowseContext";
        public static final String View_EventBrowseContext_EventDecorationRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventDecorationRule";
        public static final String View_EventBrowseContext_EventImageRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventImageRule";
        public static final String View_EventBrowseContext_EventLabelRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLabelRule";
        public static final String View_EventBrowseContext_EventLogImageRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogImageRule";
        public static final String View_EventBrowseContext_EventLogLabelRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogLabelRule";
        public static final String View_EventBrowseContext_EventLogsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventLogsRule";
        public static final String View_EventBrowseContext_EventsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/EventsRule";
        public static final String View_EventBrowseContext_ProjectEventsRule = "http://www.simantics.org/Event-1.2/View/EventBrowseContext/ProjectEventsRule";
        public static final String View_HideInfoEvents = "http://www.simantics.org/Event-1.2/View/HideInfoEvents";
        public static final String View_HideInfoEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideInfoEvents/Inverse";
        public static final String View_HideReturnEvents = "http://www.simantics.org/Event-1.2/View/HideReturnEvents";
        public static final String View_HideReturnEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideReturnEvents/Inverse";
        public static final String View_HideWarningEvents = "http://www.simantics.org/Event-1.2/View/HideWarningEvents";
        public static final String View_HideWarningEvents_Inverse = "http://www.simantics.org/Event-1.2/View/HideWarningEvents/Inverse";
        public static final String View_ManualEventType = "http://www.simantics.org/Event-1.2/View/ManualEventType";
        public static final String View_ShowHiddenEvents = "http://www.simantics.org/Event-1.2/View/ShowHiddenEvents";
        public static final String View_ShowHiddenEvents_Inverse = "http://www.simantics.org/Event-1.2/View/ShowHiddenEvents/Inverse";
        public static final String View_ShowOnlyActiveEvents = "http://www.simantics.org/Event-1.2/View/ShowOnlyActiveEvents";
        public static final String View_ShowOnlyActiveEvents_Inverse = "http://www.simantics.org/Event-1.2/View/ShowOnlyActiveEvents/Inverse";
        public static final String View_ShowOnlyMilestones = "http://www.simantics.org/Event-1.2/View/ShowOnlyMilestones";
        public static final String View_ShowOnlyMilestones_Inverse = "http://www.simantics.org/Event-1.2/View/ShowOnlyMilestones/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public EventResource(ReadGraph graph) {
        Event = getResourceOrNull(graph, URIs.Event);
        EventLog = getResourceOrNull(graph, URIs.EventLog);
        EventLog_HasBaselineEvent = getResourceOrNull(graph, URIs.EventLog_HasBaselineEvent);
        EventLog_HasBaselineEvent_Inverse = getResourceOrNull(graph, URIs.EventLog_HasBaselineEvent_Inverse);
        EventSlice = getResourceOrNull(graph, URIs.EventSlice);
        EventType = getResourceOrNull(graph, URIs.EventType);
        EventType_severity = getResourceOrNull(graph, URIs.EventType_severity);
        EventType_severity_Inverse = getResourceOrNull(graph, URIs.EventType_severity_Inverse);
        Event_index = getResourceOrNull(graph, URIs.Event_index);
        Event_index_Inverse = getResourceOrNull(graph, URIs.Event_index_Inverse);
        Event_message = getResourceOrNull(graph, URIs.Event_message);
        Event_message_Inverse = getResourceOrNull(graph, URIs.Event_message_Inverse);
        Event_milestoneLabel = getResourceOrNull(graph, URIs.Event_milestoneLabel);
        Event_milestoneLabel_Inverse = getResourceOrNull(graph, URIs.Event_milestoneLabel_Inverse);
        Event_source = getResourceOrNull(graph, URIs.Event_source);
        Event_sourceName = getResourceOrNull(graph, URIs.Event_sourceName);
        Event_sourceName_Inverse = getResourceOrNull(graph, URIs.Event_sourceName_Inverse);
        Event_source_inverse = getResourceOrNull(graph, URIs.Event_source_inverse);
        Event_tag = getResourceOrNull(graph, URIs.Event_tag);
        Event_tag_Inverse = getResourceOrNull(graph, URIs.Event_tag_Inverse);
        Event_type = getResourceOrNull(graph, URIs.Event_type);
        Event_typeNumber = getResourceOrNull(graph, URIs.Event_typeNumber);
        Event_typeNumber_Inverse = getResourceOrNull(graph, URIs.Event_typeNumber_Inverse);
        HasEventLog = getResourceOrNull(graph, URIs.HasEventLog);
        HasEventProducer = getResourceOrNull(graph, URIs.HasEventProducer);
        HasModificationCounter = getResourceOrNull(graph, URIs.HasModificationCounter);
        HasModificationCounter_Inverse = getResourceOrNull(graph, URIs.HasModificationCounter_Inverse);
        HasTimestamp = getResourceOrNull(graph, URIs.HasTimestamp);
        HasTimestamp_Inverse = getResourceOrNull(graph, URIs.HasTimestamp_Inverse);
        Hidden = getResourceOrNull(graph, URIs.Hidden);
        IsEventLogOf = getResourceOrNull(graph, URIs.IsEventLogOf);
        IsEventProducerOf = getResourceOrNull(graph, URIs.IsEventProducerOf);
        Milestone = getResourceOrNull(graph, URIs.Milestone);
        NoReturn = getResourceOrNull(graph, URIs.NoReturn);
        ReturnEvent = getResourceOrNull(graph, URIs.ReturnEvent);
        ReturnedBy = getResourceOrNull(graph, URIs.ReturnedBy);
        Returns = getResourceOrNull(graph, URIs.Returns);
        TimeStamp = getResourceOrNull(graph, URIs.TimeStamp);
        View = getResourceOrNull(graph, URIs.View);
        View_EventBrowseContext = getResourceOrNull(graph, URIs.View_EventBrowseContext);
        View_EventBrowseContext_EventDecorationRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventDecorationRule);
        View_EventBrowseContext_EventImageRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventImageRule);
        View_EventBrowseContext_EventLabelRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventLabelRule);
        View_EventBrowseContext_EventLogImageRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventLogImageRule);
        View_EventBrowseContext_EventLogLabelRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventLogLabelRule);
        View_EventBrowseContext_EventLogsRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventLogsRule);
        View_EventBrowseContext_EventsRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_EventsRule);
        View_EventBrowseContext_ProjectEventsRule = getResourceOrNull(graph, URIs.View_EventBrowseContext_ProjectEventsRule);
        View_HideInfoEvents = getResourceOrNull(graph, URIs.View_HideInfoEvents);
        View_HideInfoEvents_Inverse = getResourceOrNull(graph, URIs.View_HideInfoEvents_Inverse);
        View_HideReturnEvents = getResourceOrNull(graph, URIs.View_HideReturnEvents);
        View_HideReturnEvents_Inverse = getResourceOrNull(graph, URIs.View_HideReturnEvents_Inverse);
        View_HideWarningEvents = getResourceOrNull(graph, URIs.View_HideWarningEvents);
        View_HideWarningEvents_Inverse = getResourceOrNull(graph, URIs.View_HideWarningEvents_Inverse);
        View_ManualEventType = getResourceOrNull(graph, URIs.View_ManualEventType);
        View_ShowHiddenEvents = getResourceOrNull(graph, URIs.View_ShowHiddenEvents);
        View_ShowHiddenEvents_Inverse = getResourceOrNull(graph, URIs.View_ShowHiddenEvents_Inverse);
        View_ShowOnlyActiveEvents = getResourceOrNull(graph, URIs.View_ShowOnlyActiveEvents);
        View_ShowOnlyActiveEvents_Inverse = getResourceOrNull(graph, URIs.View_ShowOnlyActiveEvents_Inverse);
        View_ShowOnlyMilestones = getResourceOrNull(graph, URIs.View_ShowOnlyMilestones);
        View_ShowOnlyMilestones_Inverse = getResourceOrNull(graph, URIs.View_ShowOnlyMilestones_Inverse);
    }
    
    public static EventResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        EventResource ret = session.peekService(EventResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new EventResource(qc.getIndependentGraph(graph));
            session.registerService(EventResource.class, ret);
        }
        return ret;
    }
    
    public static EventResource getInstance(RequestProcessor session) throws DatabaseException {
        EventResource ret = session.peekService(EventResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<EventResource>() {
                public EventResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new EventResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(EventResource.class, ret);
        }
        return ret;
    }
    
}

