/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.simantics.editors.BrowserInput;
import org.simantics.editors.internal.SystemFile;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class Editors {
    public static IEditorPart openBrowser(URL url) throws PartInitException {
        return Editors.openBrowser(url, false);
    }

    public static IEditorPart openBrowser(URL url, boolean fullscreen) throws PartInitException {
        BrowserInput input = new BrowserInput(url, true, fullscreen);
        return WorkbenchUtils.openEditor((String)"org.simantics.editors.browser", (IEditorInput)input);
    }

    public static IEditorPart openExternalEditor(File file) throws PartInitException {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ExternalFileEditorInput input = new ExternalFileEditorInput(new SystemFile(file, ws));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        return page.openEditor((IEditorInput)input, desc.getId());
    }

    private static class ExternalFileEditorInput
    extends FileEditorInput {
        public ExternalFileEditorInput(IFile file) {
            super(file);
        }

        public void saveState(IMemento memento) {
        }
    }
}

