/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.document.FileDocumentUtil;
import org.simantics.document.ui.actions.Messages;

public class ImportDocumentFolder
implements ActionFactory {
    Resource folderType;
    Resource relation;

    public ImportDocumentFolder(ReadGraph graph, String folderTypeUri, String relationUri) throws DatabaseException {
        this.folderType = graph.getResource(folderTypeUri);
        this.relation = graph.getResource(relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 4096);
                String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                ImportJob job = new ImportJob(Messages.ImportDocumentFolder_ImportFolder, resource, filename);
                job.setUser(true);
                job.schedule();
            }
        };
    }

    private class ImportJob
    extends DatabaseJob {
        Resource resource;
        String filename;

        public ImportJob(String name, Resource resource, String filename) {
            super(name);
            this.resource = resource;
            this.filename = filename;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            try {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        try {
                            graph.markUndoPoint();
                            FileDocumentUtil.importFolderWithName((WriteGraph)graph, (String)ImportJob.this.filename, (Resource)ImportJob.this.resource, (Resource)((ImportJob)ImportJob.this).ImportDocumentFolder.this.folderType, (Resource)((ImportJob)ImportJob.this).ImportDocumentFolder.this.relation, (IProgressMonitor)monitor);
                        }
                        catch (Exception e) {
                            throw new DatabaseException((Throwable)e);
                        }
                    }
                });
                return new Status(0, "org.simantics.document.ui", Messages.ImportDocumentFolder_ActivatorFolderImported);
            }
            catch (DatabaseException e) {
                return new Status(4, "org.simantics.document.ui", Messages.ImportDocumentFolder_ActivatorCannotImportDocumentFolder, (Throwable)e);
            }
        }
    }
}

