package org.simantics.document.swt.core.widget;

import java.util.TreeMap;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.datatypes.literal.RGB;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.HasWidgetsWidgetManager;
import org.simantics.document.swt.core.base.WidgetContainer;

public class GridCell extends HasWidgetsWidgetManager<Composite> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Composite control, JSONObject object) {
	}

	@Override
	protected Composite doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		
		Boolean grabVertical = object.getJSONFieldDefault("grabVertical", false);
		Boolean grabHorizontal = object.getJSONFieldDefault("grabHorizontal", false);
		Integer span = object.getJSONFieldDefault("span", 1);

		RGB.Integer background = object.getBeanJSONFieldDefault("background", RGB.Integer.BINDING, new RGB.Integer(255,255,255));
		
		Composite result = new Composite(parent, SWT.NONE);
		GridDataFactory.fillDefaults().grab(grabHorizontal, grabVertical).span(span, 1).applyTo(result);
		GridLayoutFactory.fillDefaults().applyTo(result);
		result.setBackground(document.getColor(background));
		return result;
		
	}
	
	@Override
	public void updateChildren(SWTDocument document, JSONObject object, WidgetContainer widget, TreeMap<String, WidgetData> childMap) {
		
		super.updateChildren(document, object, widget, childMap);

		WidgetData child = childMap.values().iterator().next();
		WidgetContainer container = (WidgetContainer)child.widget;
		Control c = container.getControl();
		if(c == null || c.isDisposed()) return;
		GridDataFactory.fillDefaults().grab(true, true).minSize(1, 1).applyTo(c);
		
	}	
}
