package org.simantics.document.swt.core.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.simantics.document.server.JSONObject;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;

public class BrowserWidget extends LeafWidgetManager<Browser> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Browser control, JSONObject object) {
		if(control.isDisposed()) return;
	}

	@Override
	protected Browser doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		Browser browser = new Browser(parent, SWT.NONE);
		
		String url = object.getJSONField("url");
		if(url == null)
			url = "www.google.fi";

		System.out.println("add listener");
		parent.addListener(SWT.Paint, new Listener() {
			
			@Override
			public void handleEvent(Event event) {
				System.out.println("Show " + event.widget);
				
			}
		});
		
		browser.setUrl(url);
		
		return browser;
	}

}
