package org.simantics.document.swt.core.bean;

import java.io.IOException;

import org.simantics.browsing.ui.Column.Align;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataValueRepository;

public class ColumnsBean {

	public static final Binding BINDING = Bindings.getBindingUnchecked(ColumnsBean.class);

	public ColumnBean[] columns;
	
	public static void main(String[] args) {
		
		System.err.println(BINDING.type().toSingleLineString());
		
		ColumnBean b1 = new ColumnBean();
		b1.alignment = "CENTER";
		b1.grab = false;
		b1.key = "k";
		b1.label = "l";
		b1.tooltip = "t";
		b1.weight = 1;
		b1.width = 2;
		
		ColumnBean b2 = new ColumnBean();
		b2.alignment = "LEFT";
		b2.grab = true;
		b2.key = "k2";
		b2.label = "l2";
		b2.tooltip = "t2";
		b2.weight = 3;
		b2.width = 4;

		ColumnBean[] cbs = { b1, b2 };
		
		ColumnsBean bean = new ColumnsBean();
		bean.columns = cbs;
		
		try {
			BINDING.printValue(bean, System.out, new DataValueRepository(), true);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BindingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
}
