/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleURIVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.structural.stubs.StructuralResource2;

public class HandleEventRequest extends UnaryRead<String, AbstractEventHandler> {

    public HandleEventRequest(String id) {
        super(id);
    }

    @Override
    public AbstractEventHandler perform(ReadGraph graph) throws DatabaseException {

        StructuralResource2.getInstance(graph);

        Variable variable = graph.syncRequest(new PossibleURIVariable(parameter), TransientCacheAsyncListener.instance());
        if(variable == null) return null;

        Object handler = variable.getValue(graph);
        if(handler instanceof AbstractEventHandler)
            return (AbstractEventHandler) handler;
        else
            throw new DatabaseException("Handler for " + parameter + " is not instance of AbstractEventHandler (it is instance of " + (handler != null ? handler.getClass() : null) + ")");
    }

}