/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.layer0.Layer0;

public class ParentRelationsRequest extends ResourceRead<Collection<String>> {

	public ParentRelationsRequest(Resource widgetType) {
		super(widgetType);
	}

	@Override
	public Collection<String> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		DocumentationResource DOC = DocumentationResource.getInstance(graph);
		Collection<String> ret = null;
		Map<String,Resource> domainOf = Layer0Utils.getDomainOf(graph, resource);
		for(Resource cp : domainOf.values()) {
			if(graph.isInstanceOf(cp, DOC.Relations_parentRelation)) {
				String name = graph.getPossibleRelatedValue(cp, L0.HasName, Bindings.STRING);
				if(name != null) {
					if(ret == null) {
						ret = Collections.singleton(name);
					} else {
						if(ret.size() == 1) {
							String exist = ret.iterator().next();
							ret = new ArrayList<>(2);
							ret.add(exist);
						}
						ret.add(name);
					}
				}
			}
		}
		if(ret == null)
			return Collections.emptyList();
		return ret;
	}

}