package org.simantics.document.server.io;

public class RGBColor implements IColor {

	private final int red;
	private final int green;
	private final int blue;
	
	public RGBColor(int red, int green, int blue) {
		super();
		this.red = red;
		this.green = green;
		this.blue = blue;
	}

	@Override
	public int red() {
		return red;
	}

	@Override
	public int blue() {
		return blue;
	}

	@Override
	public int green() {
		return green;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + blue;
		result = prime * result + green;
		result = prime * result + red;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RGBColor other = (RGBColor) obj;
		if (blue != other.blue)
			return false;
		if (green != other.green)
			return false;
		if (red != other.red)
			return false;
		return true;
	}

	
}
