/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.evaluator.PredefinedVariables;
import org.simantics.document.linking.utils.Messages;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;

public class SourceLinkUtil {
    public static Resource createDocumentLink(WriteGraph graph, Resource instance, Resource relation, Resource document) throws DatabaseException {
        String uri;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource link = null;
        DependencyCheckResult result = SourceLinkUtil.checkDependecies((ReadGraph)graph, document, instance);
        if (result == DependencyCheckResult.NoLocationModel) {
            throw new DatabaseException(Messages.SourceLinkUtil_DatabaseExceptionLocNotModelPart);
        }
        if (result == DependencyCheckResult.DifferentModel) {
            throw new DatabaseException(Messages.SourceLinkUtil_DatabaseExceptionDocumentInDifferentModel);
        }
        if (result == DependencyCheckResult.NoReferenceModel && (uri = graph.getPossibleURI(document)) != null) {
            link = relation != null && graph.isInstanceOf(relation, l0.FunctionalRelation) ? SourceLinkUtil.createFunctionalSource(graph, uri, instance, relation) : SourceLinkUtil.createInstanceSource(graph, uri, instance);
        }
        if (link == null) {
            link = relation != null && graph.isInstanceOf(relation, l0.FunctionalRelation) ? SourceLinkUtil.createFunctionalSource(graph, document, instance, relation) : SourceLinkUtil.createInstanceSource(graph, document, instance);
        }
        return link;
    }

    public static Resource createDocumentLink(WriteGraph graph, Resource instance, Resource document) throws DatabaseException {
        return SourceLinkUtil.createDocumentLink(graph, instance, null, document);
    }

    public static Resource createInstanceSource(WriteGraph graph, Resource reference, Resource location) throws DatabaseException {
        return SourceLinkUtil.createInstanceSource(graph, reference, location, "");
    }

    public static Resource createInstanceSource(WriteGraph graph, Resource reference, Resource location, String comment) throws DatabaseException {
        Resource source2;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Collection sources = (Collection)graph.syncRequest((Read)new ObjectsWithType(location, sl.hasFunctionalSource, sl.InstanceSource));
        for (Resource source2 : sources) {
            if (!reference.equals(graph.getPossibleObject(source2, sl.hasSourceReference))) continue;
            return source2;
        }
        if (!SourceLinkUtil.ensureDependencies(graph, reference, location)) {
            return null;
        }
        source2 = graph.newResource();
        graph.claim(source2, l0.InstanceOf, sl.InstanceSource);
        graph.claim(source2, sl.hasSourceReference, reference);
        graph.claimLiteral(source2, sl.hasSourceComment, (Object)comment, (Binding)Bindings.STRING);
        graph.claim(location, sl.hasInstanceSource, source2);
        graph.claim(location, l0.ConsistsOf, source2);
        graph.claimLiteral(source2, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        return source2;
    }

    public static Resource createInstanceSource(WriteGraph graph, String reference, Resource location) throws DatabaseException {
        return SourceLinkUtil.createInstanceSource(graph, reference, location, "");
    }

    public static Resource createInstanceSource(WriteGraph graph, String reference, Resource location, String comment) throws DatabaseException {
        Resource source2;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Collection sources = (Collection)graph.syncRequest((Read)new ObjectsWithType(location, sl.hasFunctionalSource, sl.InstanceSource));
        for (Resource source2 : sources) {
            if (!reference.equals(graph.getPossibleRelatedValue(source2, sl.hasSourceReferenceURI, (Binding)Bindings.STRING))) continue;
            return source2;
        }
        if (!SourceLinkUtil.ensureDependencies(graph, null, location)) {
            return null;
        }
        source2 = graph.newResource();
        graph.claim(source2, l0.InstanceOf, sl.InstanceSource);
        graph.claimLiteral(source2, sl.hasSourceReferenceURI, (Object)reference, (Binding)Bindings.STRING);
        graph.claimLiteral(source2, sl.hasSourceComment, (Object)comment, (Binding)Bindings.STRING);
        graph.claim(location, sl.hasInstanceSource, source2);
        graph.claim(location, l0.ConsistsOf, source2);
        graph.claimLiteral(source2, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        return source2;
    }

    public static Resource createFunctionalSource(WriteGraph graph, Resource reference, Resource location, Resource relation) throws DatabaseException {
        return SourceLinkUtil.createFunctionalSource(graph, reference, location, relation, "");
    }

    public static Resource createFunctionalSource(WriteGraph graph, Resource reference, Resource location, Resource relation, String comment) throws DatabaseException {
        Resource source2;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Collection sources = (Collection)graph.syncRequest((Read)new ObjectsWithType(location, sl.hasFunctionalSource, sl.FunctionalSource));
        for (Resource source2 : sources) {
            if (!relation.equals(graph.getPossibleObject(source2, sl.consernsRelation)) || !reference.equals(graph.getPossibleObject(source2, sl.hasSourceReference))) continue;
            return null;
        }
        if (!SourceLinkUtil.ensureDependencies(graph, reference, location)) {
            return null;
        }
        source2 = graph.newResource();
        graph.claim(source2, l0.InstanceOf, sl.FunctionalSource);
        graph.claim(source2, sl.hasSourceReference, reference);
        graph.claimLiteral(source2, sl.hasSourceComment, (Object)comment, (Binding)Bindings.STRING);
        graph.claim(source2, sl.consernsRelation, relation);
        graph.claim(location, sl.hasFunctionalSource, source2);
        graph.claim(location, l0.ConsistsOf, source2);
        graph.claimLiteral(source2, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        return source2;
    }

    public static Resource createFunctionalSource(WriteGraph graph, String reference, Resource location, Resource relation) throws DatabaseException {
        return SourceLinkUtil.createFunctionalSource(graph, reference, location, relation, "");
    }

    public static Resource createFunctionalSource(WriteGraph graph, String reference, Resource location, Resource relation, String comment) throws DatabaseException {
        Resource source2;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Collection sources = (Collection)graph.syncRequest((Read)new ObjectsWithType(location, sl.hasFunctionalSource, sl.FunctionalSource));
        for (Resource source2 : sources) {
            if (!relation.equals(graph.getPossibleObject(source2, sl.consernsRelation)) || !reference.equals(graph.getPossibleRelatedValue(source2, sl.hasSourceReferenceURI, (Binding)Bindings.STRING))) continue;
            return null;
        }
        if (!SourceLinkUtil.ensureDependencies(graph, null, location)) {
            return null;
        }
        source2 = graph.newResource();
        graph.claim(source2, l0.InstanceOf, sl.FunctionalSource);
        graph.claimLiteral(source2, sl.hasSourceReferenceURI, (Object)reference, (Binding)Bindings.STRING);
        graph.claimLiteral(source2, sl.hasSourceComment, (Object)comment, (Binding)Bindings.STRING);
        graph.claim(source2, sl.consernsRelation, relation);
        graph.claim(location, sl.hasFunctionalSource, source2);
        graph.claim(location, l0.ConsistsOf, source2);
        graph.claimLiteral(source2, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        return source2;
    }

    public static Resource getModel(ReadGraph graph, Resource location) throws DatabaseException {
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> list = new ArrayList<Resource>();
        list.add(l0.PartOf);
        list.add(l0.IsDependencyOf);
        list.add(l0.PropertyOf);
        list.add(l0.IsOwnedBy);
        Resource r = location;
        Resource model = null;
        while (r != null) {
            if (graph.isInstanceOf(r, sim.Model)) {
                model = r;
                break;
            }
            Resource r2 = null;
            for (Resource rel : list) {
                r2 = graph.getPossibleObject(r, rel);
                if (r2 != null) break;
            }
            r = r2;
        }
        return model;
    }

    private static boolean ensureDependencies(WriteGraph graph, Resource reference, Resource location) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource model = SourceLinkUtil.getModel((ReadGraph)graph, location);
        if (model == null) {
            return true;
        }
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        HashSet<Resource> depencecies = new HashSet<Resource>();
        depencecies.add(SourceLinkUtil.getOntology((ReadGraph)graph, sl.Source));
        if (reference != null) {
            Resource refModel = SourceLinkUtil.getModel((ReadGraph)graph, reference);
            if (refModel != null && !refModel.equals(model)) {
                return false;
            }
            for (Resource t : graph.getTypes(reference)) {
                Resource o = SourceLinkUtil.getOntology((ReadGraph)graph, t);
                if (o == null) continue;
                depencecies.add(o);
            }
        }
        Collection linkedTo = graph.getObjects(model, l0.IsLinkedTo);
        for (Resource dep : depencecies) {
            if (linkedTo.contains(dep)) continue;
            graph.claim(model, l0.IsLinkedTo, dep);
        }
        return true;
    }

    private static DependencyCheckResult checkDependecies(ReadGraph graph, Resource reference, Resource location) throws DatabaseException {
        Resource model = SourceLinkUtil.getModel(graph, location);
        if (model == null) {
            return DependencyCheckResult.NoLocationModel;
        }
        Resource refModel = SourceLinkUtil.getModel(graph, reference);
        if (refModel != null) {
            if (refModel.equals(model)) {
                return DependencyCheckResult.SameModel;
            }
            return DependencyCheckResult.DifferentModel;
        }
        return DependencyCheckResult.NoReferenceModel;
    }

    private static Resource getOntology(ReadGraph graph, Resource type) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource r = type;
        while (r != null) {
            if (graph.isInstanceOf(r, l0.Ontology)) {
                return r;
            }
            r = graph.getPossibleObject(r, l0.PartOf);
        }
        r = type;
        while (r != null) {
            if (graph.isInstanceOf(r, l0.Library)) {
                return r;
            }
            r = graph.getPossibleObject(r, l0.PartOf);
        }
        return null;
    }

    public static boolean isSource(ReadGraph graph, Resource source) throws DatabaseException {
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        return graph.isInstanceOf(source, sl.Source);
    }

    public static boolean isValidSource(ReadGraph graph, Resource source) throws DatabaseException {
        Resource reference = SourceLinkUtil.getReferredDocument(graph, source);
        return SourceLinkUtil.isValidReference(graph, reference);
    }

    public static boolean isUpToDateSource(ReadGraph graph, Resource source) throws DatabaseException {
        Resource reference = SourceLinkUtil.getReferredDocument(graph, source);
        return SourceLinkUtil.isUpToDateReference(graph, reference);
    }

    public static Resource getReferredDocument(ReadGraph graph, Resource source) throws DatabaseException {
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Resource document = graph.getPossibleObject(source, sl.hasSourceReference);
        if (document != null) {
            return document;
        }
        String URI = (String)graph.getPossibleRelatedValue(source, sl.hasSourceReferenceURI, (Binding)Bindings.STRING);
        if (URI != null) {
            return graph.getPossibleResource(URI);
        }
        return null;
    }

    public static boolean isValidReference(ReadGraph graph, Resource reference) throws DatabaseException {
        if (reference == null) {
            return false;
        }
        return graph.hasStatement(reference);
    }

    public static boolean isUpToDateReference(ReadGraph graph, Resource reference) throws DatabaseException {
        if (reference == null) {
            return false;
        }
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        return !graph.hasStatement(reference, doc.HasNewerVersion);
    }

    public static void updateToLatest(WriteGraph graph, Resource source) throws DatabaseException {
        Resource r;
        Resource reference;
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(source, sl.Source)) {
            return;
        }
        Resource newRef = reference = SourceLinkUtil.getReferredDocument((ReadGraph)graph, source);
        while ((r = graph.getPossibleObject(newRef, doc.HasNewerVersion)) != null) {
            newRef = r;
        }
        if (newRef.equals(reference)) {
            return;
        }
        if (graph.hasStatement(source, sl.hasSourceReference)) {
            graph.deny(source, sl.hasSourceReference, reference);
            graph.claim(source, sl.hasSourceReference, newRef);
        } else if (graph.hasStatement(source, sl.hasSourceReferenceURI)) {
            graph.deny(source, sl.hasSourceReferenceURI);
            graph.claimLiteral(source, sl.hasSourceReferenceURI, (Object)graph.getURI(newRef), (Binding)Bindings.STRING);
        }
    }

    public static Collection<Resource> findAllSources(ReadGraph graph, Resource model, Resource resource) throws DatabaseException {
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Instances instancesQuery = (Instances)graph.adapt(sl.Source, Instances.class);
        Collection found = instancesQuery.find(graph, model);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource source : found) {
            if (!graph.hasStatement(source, sl.hasSourceReference, resource) && !graph.hasStatement(source, sl.hasSourceReferenceURI)) continue;
            result.add(source);
        }
        return result;
    }

    public static String getValueString(Object value) {
        if (value.getClass().isArray()) {
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof String[]) {
                return Arrays.toString((String[])value);
            }
            if (value instanceof Object[]) {
                return Arrays.toString((Object[])value);
            }
            return "TODO: Array " + value.getClass().getSimpleName();
        }
        return value.toString();
    }

    public static List<Resource> getPath(ReadGraph graph, Resource model, Resource obj) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> path = new ArrayList<Resource>();
        Resource r = obj;
        while (r != null && !r.equals(model)) {
            path.add(0, r);
            r = graph.getPossibleObject(r, l0.PartOf);
        }
        return path;
    }

    public static List<Resource> getDiagramPath(ReadGraph graph, Resource model, Resource obj) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        List<Resource> path = SourceLinkUtil.getPath(graph, model, obj);
        int i = path.size() - 1;
        while (i >= 0) {
            if (graph.hasStatement(path.get(i), mod.CompositeToDiagram)) {
                return path.subList(0, i + 1);
            }
            --i;
        }
        return null;
    }

    public static String getCustomizedString(ReadGraph graph, Resource document, List<String> annotationContent) throws DatabaseException {
        Object label = "";
        Variable doc = (Variable)graph.adapt(document, Variable.class);
        for (String path : annotationContent) {
            if (path.startsWith("\"") && path.endsWith("\"")) {
                label = (String)label + path.substring(1, path.length() - 1) + " ";
                continue;
            }
            Variable v = PredefinedVariables.getInstance().getVariable(graph, path, null, doc);
            if (v == null) continue;
            label = (String)label + String.valueOf(v.getValue(graph)) + " ";
        }
        return label;
    }

    private static enum DependencyCheckResult {
        NoLocationModel,
        NoReferenceModel,
        SameModel,
        DifferentModel;

    }
}

