/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import java.util.List;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.pdf.PDFDocument;
import org.simantics.document.linking.report.pdf.PDFElement;
import org.simantics.document.linking.report.pdf.PDFPage;

public class PDFTitlePage
extends DocumentTitlePage
implements PDFElement {
    PDFDocument document;
    PDFPage page;

    public PDFTitlePage(PDFDocument writer) {
        this.document = writer;
    }

    @Override
    public PDFPage getPage() {
        return this.page;
    }

    @Override
    public void writeTitle(List<DocumentLine> titleLines) throws Exception {
        Document.TextSize textSize;
        TableColumn.Alignment alignment = (TableColumn.Alignment)((Object)titleLines.get(0).getHints().get(TableColumn.Alignment.class));
        if (alignment == null) {
            alignment = TableColumn.Alignment.CENTER;
        }
        if ((textSize = (Document.TextSize)((Object)titleLines.get(0).getHints().get(Document.TextSize.class))) == null) {
            textSize = Document.TextSize.HUGE;
        }
        this.document.nextPage();
        this.page = this.document.contentStream.getCurrentPage();
        Table table = this.document.newElement(Table.class, new String[0]);
        table.addColumn("Names", 1.0).setAlignment(alignment);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        table.setTextSize(textSize);
        int lines = (this.document.contentStream.getAvailableLines() - 3) / 2;
        int i = 0;
        while (i < lines) {
            table.writeRow("");
            ++i;
        }
        for (DocumentLine line : titleLines) {
            Document.TextSize s = (Document.TextSize)((Object)line.getHints().get(Document.TextSize.class));
            if (s != null) {
                textSize = s;
            }
            table.setTextSize(textSize);
            table.writeRow(line.getLine());
        }
        table.setTextSize(Document.TextSize.SMALL);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.document.nextPage();
    }
}

