/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.simantics.document.linking.report.pdf.PDFPage;

public class PDFPageStream {
    boolean modifiable = false;
    Rectangle pageSize = PageSize.A4;
    Font defaultFont;
    List<PDFPage> pages = new ArrayList<PDFPage>();
    int contentWidth;
    int contentHeight;
    int marginLeft = 20;
    int marginRight = 20;
    int marginTop = 10;
    int marginBottom = 45;
    int currentPage = 0;

    public PDFPageStream() {
        this.calculateContent();
    }

    public PDFPageStream(Rectangle pageSize) {
        this.pageSize = pageSize;
        this.calculateContent();
    }

    public PDFPageStream(boolean modifiable) {
        this.modifiable = modifiable;
        this.calculateContent();
    }

    public PDFPageStream(Rectangle pageSize, boolean modifiable) {
        this.pageSize = pageSize;
        this.modifiable = modifiable;
        this.calculateContent();
    }

    private void calculateContent() {
        this.contentWidth = (int)this.getPageSize().getWidth() - this.marginLeft - this.marginRight;
        this.contentHeight = (int)this.getPageSize().getHeight() - this.marginTop - this.marginBottom;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public List<PDFPage> getPages() {
        return this.pages;
    }

    public void nextPage() throws Exception {
        this.endPage();
        PDFPage page = new PDFPage(this);
        this.pages.add(page);
        ++this.currentPage;
    }

    private void endPage() {
        if (this.pages.size() > 0) {
            PDFPage lastPage = this.pages.get(this.pages.size() - 1);
            if (!this.modifiable && lastPage.isOpen()) {
                lastPage.close();
            }
        }
    }

    public int getAvailableLines() {
        return this.getCurrentPage().availableLines;
    }

    public int getCurrentLine() {
        return this.getCurrentPage().currentLine;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    protected void checkNextPage() throws Exception {
        PDFPage page = this.getCurrentPage();
        if (this.contentHeight - page.currentPixel - page.getLineHeight() <= 0) {
            this.nextPage();
        }
    }

    public int getCurrentPageIndex() {
        return this.currentPage;
    }

    public PDFPage getCurrentPage() {
        return this.pages.get(this.currentPage - 1);
    }

    public void copy(PdfCopy pdfCopy) throws IOException {
        for (PDFPage page : this.pages) {
            if (page.isOpen()) {
                page.close();
            }
            PdfReader reader = new PdfReader(page.tempFile.getAbsolutePath());
            try {
                try {
                    int i = 1;
                    while (i <= reader.getNumberOfPages()) {
                        PdfImportedPage ipage = pdfCopy.getImportedPage(reader, i);
                        pdfCopy.addPage(ipage);
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reader.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
        }
    }

    public void close(String filename) throws Exception {
        if (this.pages.size() == 0) {
            return;
        }
        try {
            this.endPage();
            Document document = new Document(this.pageSize);
            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(filename));
            document.open();
            this.copy(pdfCopy);
            document.close();
            pdfCopy.close();
        }
        finally {
            this.close();
        }
    }

    public void close() throws Exception {
        for (PDFPage page : this.pages) {
            page.tempFile.delete();
        }
        this.pages.clear();
        this.defaultFont = null;
    }
}

