/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.html;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.TableRow;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.html.HTMLDocument;
import org.simantics.document.linking.report.html.HTMLTableRow;
import org.simantics.document.linking.report.html.HTMLTextElement;

public class HTMLTable
extends HTMLTextElement
implements Table {
    HTMLDocument writer;
    List<TableColumn> columns = new ArrayList<TableColumn>();
    boolean linesVisible = true;
    boolean headerVisible = true;
    TextItem title = null;
    int currentLine = 0;
    PrintStream os;
    String classID;
    boolean copyStyle = false;

    public HTMLTable(HTMLDocument writer, boolean id) {
        super(!id ? null : writer.getUniqueId(HTMLTable.class));
        this.writer = writer;
        this.os = writer.os;
        this.classID = writer.getUniqueId(this);
    }

    public HTMLTable(HTMLDocument writer, PrintStream os, boolean id) {
        super(!id ? null : writer.getUniqueId(HTMLTable.class));
        this.writer = writer;
        this.os = os;
        this.classID = writer.getUniqueId(this);
    }

    public HTMLTable(HTMLTable table, boolean id) {
        super(!id ? null : table.writer.getUniqueId(HTMLTable.class));
        this.writer = table.writer;
        this.os = table.os;
        this.columns.addAll(table.columns);
        this.classID = table.classID;
        this.copyStyle = true;
    }

    @Override
    public TableColumn addColumn(String name, double width) {
        TableColumn tc = new TableColumn(name, width);
        this.columns.add(tc);
        return tc;
    }

    @Override
    public List<TableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public void setTitle(String title) {
        try {
            this.title = this.writer.newItem(TextItem.class, new String[0]);
            this.title.setText(title);
        }
        catch (Exception exception) {}
    }

    @Override
    public void setTitle(TextItem title) {
        this.title = title;
    }

    @Override
    public TableRow writeRow(String ... line) throws Exception {
        ArrayList<String> list = new ArrayList<String>(line.length);
        String[] stringArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return this.writeRow(list);
    }

    @Override
    public TableRow writeRow(List<String> line) throws Exception {
        int i = 0;
        while (i < line.size()) {
            line.set(i, this.escape(line.get(i)));
            ++i;
        }
        return this.writeRowRaw(line);
    }

    @Override
    public TableRow writeRowItem(List<TextItem> line) throws Exception {
        int i = 0;
        while (i < line.size()) {
            TextItem text = line.get(i);
            if (text != null) {
                text.setText(this.escape(text.getText()));
            }
            ++i;
        }
        return this.writeRowRaw2(line);
    }

    @Override
    public TableRow writeRowItem(TextItem ... line) throws Exception {
        ArrayList<TextItem> list = new ArrayList<TextItem>(line.length);
        TextItem[] textItemArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            TextItem s = textItemArray[n2];
            list.add(s);
            ++n2;
        }
        return this.writeRowItem(list);
    }

    public TableRow writeRowRaw(List<String> line) throws Exception {
        if (this.currentLine == 0) {
            this.startTable();
        }
        Object clz = "\"";
        clz = (String)clz + (this.currentLine % 2 == 0 ? "even" : "odd");
        clz = (String)clz + " " + String.valueOf((Object)this.currentTextSize);
        clz = (String)clz + "\"";
        this.os.println("    <tr class=" + (String)clz + ">");
        if (line.size() > 1) {
            int i = 0;
            while (i < line.size()) {
                String s = line.get(i);
                TableColumn.Alignment a = this.columns.get(i).getAlignment();
                String tdClass = "class=\"" + a.toString() + "\"";
                if (s != null) {
                    this.os.println("      <td " + tdClass + ">" + s + "</td>");
                } else {
                    this.os.println("      <td> </td>");
                }
                ++i;
            }
        } else if (line.size() == 1) {
            String s = line.get(0);
            TableColumn.Alignment a = this.columns.get(0).getAlignment();
            String tdClass = "class=\"" + a.toString() + "\"";
            if (s != null) {
                this.os.println("      <td " + tdClass + " colspan=\"" + this.columns.size() + "\">" + s + "</td>");
            } else {
                this.os.println("      <td colspan=\"" + this.columns.size() + "\"> </td>");
            }
        } else {
            this.os.println("      <td colspan=\"" + this.columns.size() + "\"> </td>");
        }
        this.os.println("    </tr>");
        ++this.currentLine;
        ++this.writer.currentLine;
        return new HTMLTableRow(null);
    }

    public TableRow writeRowRaw2(List<TextItem> line) throws Exception {
        if (this.currentLine == 0) {
            this.startTable();
        }
        Object clz = "\"";
        clz = (String)clz + (this.currentLine % 2 == 0 ? "even" : "odd");
        clz = (String)clz + " " + String.valueOf((Object)this.currentTextSize);
        clz = (String)clz + "\"";
        this.os.println("    <tr class=" + (String)clz + ">");
        if (line.size() > 1) {
            int i = 0;
            while (i < line.size()) {
                TextItem item = line.get(i);
                TableColumn.Alignment a = this.columns.get(i).getAlignment();
                String tdClass = "class=\"" + a.toString() + "\"";
                if (item != null && item.getText() != null) {
                    this.os.println("      <td " + tdClass + ">" + item.toString() + "</td>");
                } else {
                    this.os.println("      <td> </td>");
                }
                ++i;
            }
        } else if (line.size() == 1) {
            String s = line.get(0).toString();
            TableColumn.Alignment a = this.columns.get(0).getAlignment();
            String tdClass = "class=\"" + a.toString() + "\"";
            if (s != null) {
                this.os.println("      <td " + tdClass + " colspan=\"" + this.columns.size() + "\">" + s + "</td>");
            } else {
                this.os.println("      <td colspan=\"" + this.columns.size() + "\"> </td>");
            }
        } else {
            this.os.println("      <td colspan=\"" + this.columns.size() + "\"> </td>");
        }
        this.os.println("    </tr>");
        ++this.currentLine;
        ++this.writer.currentLine;
        return new HTMLTableRow(null);
    }

    @Override
    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    @Override
    public void setLinesVisible(boolean b) {
        this.linesVisible = b;
    }

    @Override
    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    @Override
    public void setHeaderVisible(boolean b) {
        this.headerVisible = b;
    }

    void style() {
        int i = 0;
        while (i < this.columns.size()) {
            this.os.println("table." + this.classID + " th.column" + i + " {");
            this.os.println("  width: " + (int)(this.columns.get(i).getWidth() * 100.0) + "%;");
            this.os.println("}");
            ++i;
        }
    }

    void startTable() {
        if (this.id != null) {
            this.os.println("<a id=\"" + this.id + "\"></a>");
        }
        String clz = this.classID + " " + (this.linesVisible ? "lines" : "nolines");
        this.os.println("<table class=\"" + clz + "\" >");
        if (this.headerVisible) {
            if (this.title != null) {
                this.os.println("  <caption>" + String.valueOf(this.title) + "</caption>");
            }
            this.os.println("  <thead>");
            this.os.println("    <tr class=MEDIUM>");
            int ci = 0;
            for (TableColumn c : this.columns) {
                this.os.println("      <th class=\"column" + ci + "\">" + this.escape(c.getName()) + "</th>");
                ++ci;
            }
            this.os.println("    </tr>");
            this.os.println("  </thead>");
        }
        this.os.println("  <tbody>");
    }

    void endTable() throws Exception {
        if (this.currentLine > 0) {
            this.os.println("  </tbody>");
            this.os.println("</table>");
            this.os.println("<br>");
            if (!this.copyStyle) {
                this.os.println("<style>");
                this.style();
                this.os.println("</style>");
            }
        }
    }

    private String escape(String s) {
        return s;
    }
}

