/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.evaluator.EvaluatorNode;
import org.simantics.document.linking.report.evaluator.StringEditableNode;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

@OrderedSetType(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Path")
public class Path
extends EvaluatorNode
implements StringEditableNode {
    String separator;

    public Path() {
        this.separator = "/";
    }

    public Path(String separator) {
        this.separator = separator;
    }

    public String toString() {
        return "path (" + this.separator + ")";
    }

    @Override
    public String setValue(String value) {
        this.separator = value;
        return null;
    }

    @RelatedSetValue(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue")
    public void _setValue(String value) {
        this.separator = value;
    }

    @Override
    @RelatedGetValue(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue")
    public String getValue() {
        return this.separator;
    }

    @Override
    public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
        Resource model = (Resource)context.get("model");
        Object text = "";
        Variable parent = variable.getParent(graph);
        while (parent != null) {
            text = ((EvaluatorItem)this.children.get(0)).getValue(graph, parent, context) + this.separator + (String)text;
            if (!model.equals((parent = parent.getParent(graph)).getRepresents(graph))) continue;
            parent = null;
        }
        if (((String)text).length() == 0) {
            return null;
        }
        return ((String)text).substring(0, ((String)text).length() - this.separator.length());
    }

    @Override
    public List<DocumentLine> getLines(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
        ArrayList<DocumentLine> result = new ArrayList<DocumentLine>();
        Resource model = (Resource)context.get("model");
        int i = 0;
        while (i < this.children.size()) {
            Variable parent = variable.getParent(graph);
            while (parent != null) {
                List<DocumentLine> list = ((EvaluatorItem)this.children.get(i)).getLines(graph, parent, context);
                int j = 0;
                while (j < list.size()) {
                    DocumentLine line = list.get(j);
                    if (j <= result.size()) {
                        result.add(line);
                    } else {
                        DocumentLine extLine = (DocumentLine)result.get(j);
                        String combined = line.getLine() + this.separator + extLine.getLine();
                        HashMap<Object, Object> combinedSet = new HashMap<Object, Object>();
                        combinedSet.putAll(extLine.getHints());
                        combinedSet.putAll(line.getHints());
                        result.set(j, new DocumentLine(combined, combinedSet));
                    }
                    ++j;
                }
                if (!model.equals((parent = parent.getParent(graph)).getRepresents(graph))) continue;
                parent = null;
            }
            ++i;
        }
        return result;
    }

    @Override
    public ImageDescriptor getImage() {
        return Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/folder.png");
    }

    @Override
    public EvaluatorItem copy() {
        Path path = new Path();
        return path;
    }

    @Override
    public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
        if (add && this.children.size() > 0) {
            return Collections.emptyList();
        }
        return super.getPossibleChildren(add);
    }

    @Override
    public boolean acceptChild(EvaluatorItem item) {
        return this.children.size() == 0;
    }

    @Override
    public boolean acceptChild(int index, EvaluatorItem item) {
        return this.children.size() == 0;
    }
}

