/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ge.ObjectChildRule;
import org.simantics.document.linking.ge.PropertyChildRule;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.layer0.Layer0;

public class ModelChildRule
implements ChildRule {
    private ObjectChildRule objectChildRule;
    private PropertyChildRule propertyChildRule;
    private boolean showOnlyCheckable = false;

    public ModelChildRule(ReadGraph graph, Resource r) {
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        this.showOnlyCheckable = sl.ModelViewpointBrowseContext2_ChildRule.equals(r);
        this.objectChildRule = new ObjectChildRule();
        this.propertyChildRule = new PropertyChildRule(false);
        this.objectChildRule.setShowOnlyCheckable(this.showOnlyCheckable);
        this.propertyChildRule.setShowOnlyCheckable(this.showOnlyCheckable);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public Collection<?> getChildren(ReadGraph graph, Object obj) throws DatabaseException {
        ArrayList<Object> children = new ArrayList<Object>();
        Resource resource = null;
        Variable variable = null;
        if (obj instanceof Resource) {
            resource = (Resource)obj;
            try {
                variable = (Variable)graph.adapt(resource, Variable.class);
            }
            catch (Throwable throwable) {
                return children;
            }
            children.add(new StandardGraphChildVariable(variable, null, resource));
            return children;
        }
        variable = (Variable)obj;
        resource = variable.getPossibleRepresents(graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, sl.Source)) {
            return children;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(resource, l0.ConsistsOf)) {
            StandardGraphChildVariable v = new StandardGraphChildVariable(variable, null, r);
            if (!this.hasLinkedChildren(graph, (Variable)v)) continue;
            children.add(v);
        }
        children.addAll(this.objectChildRule.getChildren(graph, variable));
        children.addAll(this.propertyChildRule.getChildren(graph, variable));
        return children;
    }

    private boolean hasLinkedChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        if (this.getLinkChildren(graph, variable).size() > 0) {
            return true;
        }
        Collection<Variable> children = this.getObjectChildren(graph, variable);
        if (children.size() == 0) {
            return false;
        }
        for (Variable child : children) {
            if (!this.hasLinkedChildren(graph, child)) continue;
            return true;
        }
        return false;
    }

    private Collection<Variable> getObjectChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<Variable> children = new ArrayList<Variable>();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(variable.getRepresents(graph), l0.ConsistsOf)) {
            children.add((Variable)new StandardGraphChildVariable(variable, null, r));
        }
        return children;
    }

    private Collection<?> getLinkChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList children = new ArrayList();
        children.addAll(this.objectChildRule.getChildren(graph, variable));
        children.addAll(this.propertyChildRule.getChildren(graph, variable));
        return children;
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return new ArrayList();
    }
}

