/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.actions.Messages;
import org.simantics.document.linking.ge.FixAllReferencesAction;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;

public class UpdateReferencesAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource document = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Collection coll = (Collection)Simantics.getSession().syncRequest((Read)new Read<Collection<Resource>>(){

                        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                            return UpdateReferencesAction.findDocumentReferences(graph, document);
                        }
                    });
                    if (coll == null) {
                        return;
                    }
                    String dialogTitle = Messages.UpdateReferencesAction_FixReferences;
                    String dialogMessage = NLS.bind((String)Messages.UpdateReferencesAction_FixOldReferences, (Object)coll.size());
                    String[] dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                    int defaultIndex = 0;
                    if (coll.size() == 0) {
                        dialogMessage = Messages.UpdateReferencesAction_NothingToFix;
                        dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL};
                        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 5, dialogButtonLabels, defaultIndex);
                        dialog.open();
                        return;
                    }
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 5, dialogButtonLabels, defaultIndex);
                    if (dialog.open() != 0) {
                        return;
                    }
                    Simantics.getSession().markUndoPoint();
                    UpdateReferencesAction.fixDocumentReferences(coll);
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)Messages.UpdateReferencesAction_CannotUpdateReferences, (Throwable)e);
                }
            }
        };
    }

    public static Collection<Resource> findDocumentReferences(ReadGraph graph, Resource document) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (!graph.hasStatement(document, doc.HasNewerVersion)) {
            return null;
        }
        Resource model = SourceLinkUtil.getModel(graph, document);
        if (model == null) {
            return null;
        }
        return SourceLinkUtil.findAllSources(graph, model, document);
    }

    public static void fixDocumentReferences(Collection<Resource> resources) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new FixAllReferencesAction.FixAll((Pair<Collection<Resource>, Collection<Resource>>)new Pair(resources, Collections.emptyList())));
    }
}

