package org.simantics.document.linking.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;

public abstract class ModelToComboListener implements org.simantics.db.procedure.Listener<Collection<NamedResource>> {
	
	/**
	 * 
	 */
	private CCombo combo;
	private boolean disposed = false;
	
	public ModelToComboListener(CCombo combo) {
		this.combo = combo;
	}
	
	public abstract Resource getCurrentModel();
	
	@Override
	public void execute(final Collection<NamedResource> result) {
		Display.getDefault().asyncExec(new Runnable() {
			
			@Override
			public void run() {
				if(combo.isDisposed()) {
					disposed = true;
					return;
				}
				
				List<NamedResource> models = new ArrayList<NamedResource>();
				models.addAll(result);
				Collections.sort(models);
				
				int index = -1;
				
				//populate the combo
				combo.removeAll();
				index = -1;
				int i = 0; 
				for (NamedResource model : models) {
					combo.add(model.getName());
					combo.setData(Integer.toString(i), model.getResource());
					if (model.getResource().equals(getCurrentModel()))
						index = i;
					i++;
				}
				
				// restore the selection
				if (index >= 0) {
					combo.select(index);
				}
				loaded();
			}
		});
		
	}
	
	public void loaded() {
		
	}
	
	@Override
	public void exception(Throwable t) {
		
	}
	
	@Override
	public boolean isDisposed() {
		return disposed || combo.isDisposed();
	}
	
	public void dispose() {
		disposed = true;
	}
}