package org.simantics.document.linking.report.templates;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;

class SourceReferenceComparator extends ResourceNameComparator {
	private DocumentLink sl;
	public SourceReferenceComparator(ReadGraph graph, Resource model) {
		super(graph,model);
		sl = DocumentLink.getInstance(graph);
	}

	
	@Override
	public int compare(Resource o1, Resource o2) {
		try {
			Resource doc1 = null;
			Resource doc2 = null;
			if (o1 != null)
				doc1 = SourceLinkUtil.getReferredDocument(graph, o1);
			if (o2 != null)
				doc2 = SourceLinkUtil.getReferredDocument(graph, o2);
			if (doc1 != null) {
				if (doc2 != null)
					return super.compare(doc1,doc2);
				return 1;
			} else if (doc2 != null)
				return -1;
			return 0;
		} catch (Exception e) {
			return 0;
		}
		
	}
}