package org.simantics.document.linking.report.templates;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;

class SourceParentHierarchyComparator extends ResourceNameComparator {
	DocumentLink sl;
	
	public SourceParentHierarchyComparator(ReadGraph graph, Resource model) {
		super(graph,model);
		sl = DocumentLink.getInstance(graph);
	}
	
	
	@Override
	public int compare(Resource o1, Resource o2) {
		try {
			Resource r1 = graph.getSingleObject(o1, sl.hasSource_Inverse);
			Resource r2 = graph.getSingleObject(o2, sl.hasSource_Inverse);
			List<Resource> path1 = getPath(r1);
			List<Resource> path2 = getPath(r2);
			int count = Math.min(path1.size(), path2.size());
			for (int i = 0; i < count; i++) {
				int comp = super.compare(path1.get(i), path2.get(i));
				if (comp != 0)
					return comp;
			}
			return path1.size() - path2.size();
			
		} catch (Exception e) {
			return 0;
		}
		
	}
}