package org.simantics.document.linking.report.templates;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;

class SourceParentComparator extends ResourceNameComparator {
	DocumentLink sl;
	public SourceParentComparator(ReadGraph graph, Resource model) {
		super(graph,model);
		sl = DocumentLink.getInstance(graph);
	}
	
	@Override
	public int compare(Resource o1, Resource o2) {
		try {
			Resource r1 = graph.getSingleObject(o1, sl.hasSource_Inverse);
			Resource r2 = graph.getSingleObject(o2, sl.hasSource_Inverse);
			int comp = super.compare(r1,r2);
			if (comp == 0) {
				Resource rel1 = graph.getPossibleObject(o1, sl.consernsRelation);
				Resource rel2 = graph.getPossibleObject(o2, sl.consernsRelation);
				if (rel1 != null) {
					if (rel2 != null)
						return super.compare(rel1,rel2);
					return 1;
				} else if (rel2 != null)
					return -1;
				return 0;
			} else {
				return comp;
			}
		} catch (Exception e) {
			return 0;
		}
		
	}
}