package org.simantics.document.linking.report.templates;

import java.util.Comparator;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.strings.AlphanumComparator;

public class PathComparator implements Comparator<List<Resource>>{
	
	private ReadGraph graph;
	
	public PathComparator(ReadGraph graph) {
		this.graph = graph;
	}
	
	@Override
	public int compare(List<Resource> o1, List<Resource> o2) {
		int common = Math.min(o1.size(), o2.size());
		for (int i = 0; i < common; i++) {
			if (o1.get(i).equals(o2.get(i)))
				continue;
			try {
				Resource r1 = o1.get(i);
				Resource r2 = o2.get(i);
				String l1 = getText(r1);
				String l2 = getText(r2);
				int c = AlphanumComparator.COMPARATOR.compare(l1, l2);
				if (c == 0) {
					if (r1.getResourceId() > r2.getResourceId())
						return 1;
					if (r1.getResourceId() < r2.getResourceId())
						return -1;
					return 0;
				}
				return c;
			} catch (DatabaseException e) {
				return 0;
			}
		}
		return o1.size() - o2.size();
	}
	
	public String getText(Resource r) throws DatabaseException {
		String l1 = NameUtils.getSafeLabel(graph, r);
		if (l1.length() == 0)
			l1 = NameUtils.getSafeName(graph, r);
		return l1;
	}

}
