package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.datastructures.MapList;


public class DiagramStructureWithDependenciesWriter extends DiagramStructureWriter{
	
	@Override
	public String getName() {
		return "Diagram structure with dependencies"; //$NON-NLS-1$
	}
	
	@Override
	public List<Resource> getReportItems(ReadGraph graph) throws Exception {
		Instances instancesQuery = graph.adapt(sl.Source, Instances.class);
        Collection<Resource> found = instancesQuery.find(graph, model);
        List<Resource> list = new ArrayList<Resource>();
        MapList<Resource, Resource> diagramToReference = new MapList<Resource, Resource>();
        for (Resource source : found) {
        	Resource parent = graph.getSingleObject(source, sl.hasSource_Inverse);
        	List<Resource> path = SourceLinkUtil.getPath(graph, model, parent);
        	for (Resource r : path) {
        		if (graph.hasStatement(r, mod.CompositeToDiagram)){
        			Resource doc = SourceLinkUtil.getReferredDocument(graph, source);
        			if (doc != null && !diagramToReference.contains(r, doc)) {
        				diagramToReference.add(r,doc);
        				list.add(source);
        			}
        		}
        	}
        }
        Collections.sort(list, diagramDocumentComparator);
        return list;
	}

}
