package org.simantics.document.linking.report.evaluator;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;


@GraphType(DocumentLink.URIs.EvaluatorTree_Variable)
public class Variable extends EvaluatorLeaf implements StringEditableNode{
	
	String variableRef = "#HasName"; //$NON-NLS-1$
	
	public Variable() {
		
	}
	
	public Variable(String variableRef) {
		this.variableRef = variableRef;
	}
	
	public void setVariableRef(String variableRef) {
		this.variableRef = variableRef;
	}
	
	public String getVariableRef() {
		return variableRef;
	}
	
	@Override
	public String getValue(ReadGraph graph, org.simantics.db.layer0.variable.Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (context.containsKey(variableRef))
			return SourceLinkUtil.getValueString(context.get(variableRef));
		try {
			org.simantics.db.layer0.variable.Variable propertyVar = PredefinedVariables.getInstance().getVariable(graph, variableRef, null, variable);
			if (propertyVar.getRepresents(graph) == null)
				return null;
			return SourceLinkUtil.getValueString(propertyVar.getValue(graph));
		} catch (Exception e) {
			return null;
		}
	}
	
	
	

	@Override
	public String toString() {
		return variableRef;
	}
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return variableRef;
	}
	
	
	@Override
	public String setValue(String value) {
		if (value.length() == 0)
			return "Variable reference cannot be empty"; //$NON-NLS-1$
		variableRef = value;
		return null;
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	public void _setValue(String value) {
		variableRef = value;
	}
	
	
	@Override
	public EvaluatorItem copy() {
		return new Variable(variableRef);
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/database_go.png"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	

}
