package org.simantics.document.linking.report.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;


/**
 * Or node returns the first non null value of children.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */

@OrderedSetType(DocumentLink.URIs.EvaluatorTree_Or)
public class Or extends EvaluatorNode{
	
	
	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		
		for (int i = 0 ; i < children.size(); i++) {
			String s =  children.get(i).getValue(graph, variable, context);
			if (s != null && s.length() > 0)
				return s;
		}
		
		return null;
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph,	Variable variable, Map<Object, Object> context) throws DatabaseException {
		for (int i = 0 ; i < children.size(); i++) {
			List<DocumentLine> list = children.get(i).getLines(graph, variable, context);
			if (list.size() > 0)
				return list;
		}
		return Collections.emptyList();
	}
	
	@Override
	public String toString() {
		return "or"; //$NON-NLS-1$
	}
	
	@Override
	public EvaluatorItem copy() {
		Or or = new Or();
		copyChildren(or);
		return or;
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_list_numbers.png"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	

}
