package org.simantics.document.linking.report.evaluator;

import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.report.DocumentLine;


/**
 * Base interface for user configurable content.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface EvaluatorItem {
	
	/**
	 * Returns rootNode of the evaluation tree, or null.
	 * @return
	 */
	public EvaluatorRoot getRoot();
	
	/**
	 * Return parent node, or null.
	 * @return
	 */
	public EvaluatorNode getParent();
	
	/**
	 * Sets parent node. This method is for internal use only. 
	 * @param parent
	 */
	void setParent(EvaluatorNode parent);
	
	/**
	 * Returns result of evaluation as a single String. Lines are separated with line.separator system property. All styling hints are omitted.
	 * @param graph
	 * @param variable
	 * @param context
	 * @return
	 * @throws DatabaseException
	 */
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException;
	
	/**
	 * Returns result of evaluation as collection of lines with styling hints.
	 * @param graph
	 * @param variable
	 * @param context
	 * @return
	 * @throws DatabaseException
	 */
	public List<DocumentLine> getLines(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException;
	
	/**
	 * Copies the evaluation node and its children.
	 * @return
	 */
	public EvaluatorItem copy();
	
	
	
	public ImageDescriptor getImage();
	
	
	
}
