package org.simantics.document.linking.ge;

import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.L0StringModifier;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;

public class VariableModifierRule implements ModifierRule{
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return true;
	}
	
	@Override
	public Modifier getModifier(ReadGraph graph, Object content,
			String columnKey) throws DatabaseException {
		
		if(!(content instanceof Variable)) {
			return null;
		}
		
		Variable variable = (Variable)content;
		Resource source = variable.getPossibleRepresents(graph);
		if (source == null)
			return null;
		
		DocumentLink sl = DocumentLink.getInstance(graph);
		if (!graph.isInstanceOf(source, sl.Source))
			return null;
		if (columnKey.equals(Constants.COMMENT)) {
			Resource commentRes = graph.getSingleObject(source, sl.hasSourceComment);
			return new L0StringModifier(graph.getSession(),commentRes);
		}
		return null;
	}

}
