package org.simantics.document.linking.ge;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.AdaptionUtils;

public class SourceObjectDropAction implements DropActionFactory {
	
	
	@Override
	public Runnable create(ReadGraph g, Object target, Object source, int operation)
			throws DatabaseException {
		Variable t = (Variable)target;
        Resource s = AdaptionUtils.adaptToSingle(source, Resource.class);
        if (s == null) {
        	Variable sv = AdaptionUtils.adaptToSingle(source, Variable.class);
        	if (sv != null)
        		s = sv.getRepresents(g);
        }

        if(t == null || s == null)
            return null;
        DocumentLink sl = DocumentLink.getInstance(g);
        if (g.isInstanceOf(s, sl.Source)) {
        	return null;
        }
		return getRunnable(t, s);
	}
	
	private Runnable getRunnable(final Variable tv, final Resource s) {
		return new Runnable() {
			
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						Layer0 l0 = Layer0.getInstance(graph);
						
						Resource relation = tv.getPossiblePredicateResource(graph);
						Resource instance; 
						if (relation != null && graph.isInstanceOf(relation, l0.FunctionalRelation)) {
							instance = tv.getParent(graph).getPossibleRepresents(graph);
						} else {
							instance = tv.getPossibleRepresents(graph);
						}
						if (instance == null)
							return;
						
						try {
							SourceLinkUtil.createDocumentLink(graph, instance, relation, s);
						} catch (final DatabaseException e) {
							String l = NameUtils.getSafeLabel(graph, s);
							if (l.length() == 0)
								l = NameUtils.getSafeName(graph, s);
							final String label = l;
							Display.getDefault().asyncExec(new Runnable() {
								
								@Override
								public void run() {
									String dialogMessage = NLS.bind(Messages.SourceObjectDropAction_CannotCreateDocumentLink , new Object[] { label , e.getMessage() }); 
									MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.SourceObjectDropAction_DocumentLink, null, dialogMessage, MessageDialog.INFORMATION, new String[]{ IDialogConstants.OK_LABEL }, 0); 
									dialog.open();
								}
							});
						}
					}
				});
				
			}
		};
		
	}
	
	
	
	
}
