package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Map;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.browsing.ui.swt.DefaultExplorerSelectionListener;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;

public class SourceLinkExplorerComposite extends GraphExplorerComposite {
	
	volatile DndBrowseContext dndBrowseContext;
	private IWorkbenchSite site;
	private MultiSelectionProvider provider;
	
    public SourceLinkExplorerComposite(Map<String, Object> args, MultiSelectionProvider provider, IWorkbenchSite site, Composite parent,  WidgetSupport support, int style) {
        super(args, site, parent, support, style);
        this.site = site;
        this.provider = provider;
        attachDND();
        
    }
    
    public SourceLinkExplorerComposite(Map<String, Object> args, MultiSelectionProvider provider, IWorkbenchSite site, Composite parent,  WidgetSupport support, boolean useDND, int style) {
        super(args, site, parent, support, style);
        this.site = site;
        this.provider = provider;
        if (useDND)
        	attachDND();
    }
    
    private void attachDND() {
    	Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException { 
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : getBrowseContexts()) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext != null)
                        browseContexts.add(browseContext);
                }
                try {
                    dndBrowseContext = DndBrowseContext.create(graph, browseContexts);
                } catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        });
    }
    
    @Override
    public void handleDrop(final Object data, final NodeContext target) {
        if (target == null)
            return;

        Simantics.getSession().asyncRequest(new Read<Runnable>() {
            @Override
            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (dndBrowseContext == null)
                    return null;
                return dndBrowseContext.getAction(graph, target, data);
            }
        }, new Procedure<Runnable>() {
            @Override
            public void execute(Runnable result) {
                if (result != null)
                    result.run();
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(t);
            }
        });
    }
    
    public void setWorkbenchListeners() {
        if (workbenchSelectionListener == null && site != null) {
            ISelectionProvider selectionProvider = (ISelectionProvider) explorer.getAdapter(ISelectionProvider.class);
            //site.setSelectionProvider(selectionProvider);
            provider.addSelectionProvider(selectionProvider);

            // Listen to the workbench selection also to propagate it to
            // the explorer also.
            workbenchSelectionListener = new DefaultExplorerSelectionListener(site.getPage().getActivePart(), explorer);
            //System.out.println("ADD WORKBENCH SELECTION LISTENER: " + workbenchSelectionListener);
            site.getWorkbenchWindow().getSelectionService().addPostSelectionListener(workbenchSelectionListener);
        }
    }
	

}
