package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;

/**
 * A rule for browsing document links of an object. Properties are not included.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ObjectChildRule implements org.simantics.browsing.ui.model.children.ChildRule{
	
	private boolean showOnlyCheckable = false;
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Resource.class) || contentType.equals(Variable.class);
	}
	
	public void setShowOnlyCheckable(boolean showOnlyCheckable) {
		this.showOnlyCheckable = showOnlyCheckable;
	}
	
	@Override
	public Collection<?> getChildren(ReadGraph graph, Object obj)
			throws DatabaseException {

		ArrayList<Variable> children = new ArrayList<Variable>();
		

		Resource resource = null;
		Variable variable = null;
		if (obj instanceof Resource) {
			resource = (Resource)obj;
			try {
				variable = graph.adapt(resource, Variable.class);
			} catch (Throwable t) {
				return children;
			}
			children.add(new StandardGraphChildVariable(variable, null, resource));
			return children;
		} else {
			variable = (Variable)obj;
			resource = variable.getPossibleRepresents(graph);
		}
		
	
		DocumentLink sl = DocumentLink.getInstance(graph);
		if (graph.isInstanceOf(resource, sl.Source))
			return children;
		
		
		//find sources declared on parentResource using consernsRelation
		Variable parentVariable = variable.getParent(graph);
		Resource parentRes = null;
		Resource relation = null;
		if (parentVariable != null) {
			parentRes = parentVariable.getPossibleRepresents(graph);
			relation = variable.getPossiblePredicateResource(graph);
		}
		
		if (parentRes != null && relation != null) {
			Collection<Resource> sources = graph.getObjects(parentRes, sl.hasSource);
			for (Resource source : sources) {
				Resource rel = graph.getPossibleObject(source, sl.consernsRelation);
				if (rel != null && rel.equals(relation)) {
					if (showOnlyCheckable && 
						(SourceLinkUtil.isValidSource(graph, source) &&
						 SourceLinkUtil.isUpToDateSource(graph, source)))
						continue;
					children.add(new StandardGraphChildVariable(variable, null, source));
				}
			}
		}
		//find sources declared on this resource, ie. sources that do not have consernsRelation.
		Collection<Resource> sources = graph.getObjects(resource, sl.hasSource);
		for (Resource source : sources) {
			Resource rel = graph.getPossibleObject(source, sl.consernsRelation);
			if (rel == null) {
				if (showOnlyCheckable && 
				   (SourceLinkUtil.isValidSource(graph, source) &&
				    SourceLinkUtil.isUpToDateSource(graph, source)))
					continue;
				children.add(new StandardGraphChildVariable(variable, null, source));
			}
		}
		while (children.remove(variable)) {
			
		}
		

		return children;
	}
	
	@Override
	public Collection<?> getParents(ReadGraph graph, Object child)
			throws DatabaseException {
		return new ArrayList<Resource>();
	}

}
