package org.simantics.document.linking.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class DocumentLink {
    
    public final Resource EvaluatorTree;
    public final Resource EvaluatorTree_AligmentHint;
    public final Resource EvaluatorTree_And;
    public final Resource EvaluatorTree_Constant;
    public final Resource EvaluatorTree_Date;
    public final Resource EvaluatorTree_HasValue;
    public final Resource EvaluatorTree_HasValue_Inverse;
    public final Resource EvaluatorTree_If;
    public final Resource EvaluatorTree_Lines;
    public final Resource EvaluatorTree_Node;
    public final Resource EvaluatorTree_Or;
    public final Resource EvaluatorTree_Path;
    public final Resource EvaluatorTree_Root;
    public final Resource EvaluatorTree_Template;
    public final Resource EvaluatorTree_TextSizeHint;
    public final Resource EvaluatorTree_Variable;
    public final Resource FunctionalSource;
    public final Resource InstanceSource;
    public final Resource ModelViewpointActionContext;
    public final Resource ModelViewpointBrowseContext;
    public final Resource ModelViewpointBrowseContext2;
    public final Resource ModelViewpointBrowseContext2_ChildRule;
    public final Resource ModelViewpointBrowseContext_ChildRule;
    public final Resource ReportTemplate;
    public final Resource SearchContribution;
    public final Resource SearchFunction;
    public final Resource Source;
    public final Resource SourceObjectViewpointActionContext;
    public final Resource SourceObjectViewpointActionContext_Category;
    public final Resource SourceObjectViewpointBrowseContext;
    public final Resource SourceObjectViewpointBrowseContext_ChildRule;
    public final Resource SourcePropertyViewpointActionContext;
    public final Resource SourcePropertyViewpointActionContext_Category;
    public final Resource SourcePropertyViewpointActionContext_FixAll;
    public final Resource SourcePropertyViewpointActionContext_FixAllReferences;
    public final Resource SourcePropertyViewpointActionContext_Open;
    public final Resource SourcePropertyViewpointActionContext_OpenWith;
    public final Resource SourcePropertyViewpointActionContext_Remove;
    public final Resource SourcePropertyViewpointActionContext_RemoveSource;
    public final Resource SourcePropertyViewpointActionContext_Replace;
    public final Resource SourcePropertyViewpointActionContext_ReplaceWithLatest;
    public final Resource SourcePropertyViewpointActionContext_ShowDocument;
    public final Resource SourcePropertyViewpointActionContext_ShowDocumentExternal;
    public final Resource SourcePropertyViewpointActionContext_SourceObjectDropAction;
    public final Resource SourcePropertyViewpointActionContext_SourceReferenceOldTest;
    public final Resource SourcePropertyViewpointActionContext_VariableInstanceTest;
    public final Resource SourcePropertyViewpointBrowseContext;
    public final Resource SourcePropertyViewpointBrowseContext_ChildRule;
    public final Resource SourcePropertyViewpointBrowseContext_Variable;
    public final Resource SourcePropertyViewpointBrowseContext_VariableImageDecorationRule;
    public final Resource SourcePropertyViewpointBrowseContext_VariableImageRule;
    public final Resource SourcePropertyViewpointBrowseContext_VariableLabelRule;
    public final Resource SourcePropertyViewpointBrowseContext_VariableModifierRule;
    public final Resource consernsRelation;
    public final Resource hasFunctionalSource;
    public final Resource hasFunctionalSource_Inverse;
    public final Resource hasInstanceSource;
    public final Resource hasInstanceSource_Inverse;
    public final Resource hasSource;
    public final Resource hasSourceComment;
    public final Resource hasSourceComment_Inverse;
    public final Resource hasSourceReference;
    public final Resource hasSourceReferenceURI;
    public final Resource hasSourceReferenceURI_Inverse;
    public final Resource hasSource_Inverse;
        
    public static class URIs {
        public static final String EvaluatorTree = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree";
        public static final String EvaluatorTree_AligmentHint = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/AligmentHint";
        public static final String EvaluatorTree_And = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/And";
        public static final String EvaluatorTree_Constant = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Constant";
        public static final String EvaluatorTree_Date = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Date";
        public static final String EvaluatorTree_HasValue = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue";
        public static final String EvaluatorTree_HasValue_Inverse = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue/Inverse";
        public static final String EvaluatorTree_If = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/If";
        public static final String EvaluatorTree_Lines = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Lines";
        public static final String EvaluatorTree_Node = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Node";
        public static final String EvaluatorTree_Or = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Or";
        public static final String EvaluatorTree_Path = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Path";
        public static final String EvaluatorTree_Root = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Root";
        public static final String EvaluatorTree_Template = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Template";
        public static final String EvaluatorTree_TextSizeHint = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/TextSizeHint";
        public static final String EvaluatorTree_Variable = "http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/Variable";
        public static final String FunctionalSource = "http://www.simantics.org/DocumentLink-1.0/FunctionalSource";
        public static final String InstanceSource = "http://www.simantics.org/DocumentLink-1.0/InstanceSource";
        public static final String ModelViewpointActionContext = "http://www.simantics.org/DocumentLink-1.0/ModelViewpointActionContext";
        public static final String ModelViewpointBrowseContext = "http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext";
        public static final String ModelViewpointBrowseContext2 = "http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext2";
        public static final String ModelViewpointBrowseContext2_ChildRule = "http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext2/ChildRule";
        public static final String ModelViewpointBrowseContext_ChildRule = "http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext/ChildRule";
        public static final String ReportTemplate = "http://www.simantics.org/DocumentLink-1.0/ReportTemplate";
        public static final String SearchContribution = "http://www.simantics.org/DocumentLink-1.0/SearchContribution";
        public static final String SearchFunction = "http://www.simantics.org/DocumentLink-1.0/SearchFunction";
        public static final String Source = "http://www.simantics.org/DocumentLink-1.0/Source";
        public static final String SourceObjectViewpointActionContext = "http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointActionContext";
        public static final String SourceObjectViewpointActionContext_Category = "http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointActionContext/Category";
        public static final String SourceObjectViewpointBrowseContext = "http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointBrowseContext";
        public static final String SourceObjectViewpointBrowseContext_ChildRule = "http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointBrowseContext/ChildRule";
        public static final String SourcePropertyViewpointActionContext = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext";
        public static final String SourcePropertyViewpointActionContext_Category = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/Category";
        public static final String SourcePropertyViewpointActionContext_FixAll = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/FixAll";
        public static final String SourcePropertyViewpointActionContext_FixAllReferences = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/FixAllReferences";
        public static final String SourcePropertyViewpointActionContext_Open = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/Open";
        public static final String SourcePropertyViewpointActionContext_OpenWith = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/OpenWith";
        public static final String SourcePropertyViewpointActionContext_Remove = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/Remove";
        public static final String SourcePropertyViewpointActionContext_RemoveSource = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/RemoveSource";
        public static final String SourcePropertyViewpointActionContext_Replace = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/Replace";
        public static final String SourcePropertyViewpointActionContext_ReplaceWithLatest = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/ReplaceWithLatest";
        public static final String SourcePropertyViewpointActionContext_ShowDocument = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/ShowDocument";
        public static final String SourcePropertyViewpointActionContext_ShowDocumentExternal = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/ShowDocumentExternal";
        public static final String SourcePropertyViewpointActionContext_SourceObjectDropAction = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/SourceObjectDropAction";
        public static final String SourcePropertyViewpointActionContext_SourceReferenceOldTest = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/SourceReferenceOldTest";
        public static final String SourcePropertyViewpointActionContext_VariableInstanceTest = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext/VariableInstanceTest";
        public static final String SourcePropertyViewpointBrowseContext = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext";
        public static final String SourcePropertyViewpointBrowseContext_ChildRule = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/ChildRule";
        public static final String SourcePropertyViewpointBrowseContext_Variable = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/Variable";
        public static final String SourcePropertyViewpointBrowseContext_VariableImageDecorationRule = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/VariableImageDecorationRule";
        public static final String SourcePropertyViewpointBrowseContext_VariableImageRule = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/VariableImageRule";
        public static final String SourcePropertyViewpointBrowseContext_VariableLabelRule = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/VariableLabelRule";
        public static final String SourcePropertyViewpointBrowseContext_VariableModifierRule = "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext/VariableModifierRule";
        public static final String consernsRelation = "http://www.simantics.org/DocumentLink-1.0/consernsRelation";
        public static final String hasFunctionalSource = "http://www.simantics.org/DocumentLink-1.0/hasFunctionalSource";
        public static final String hasFunctionalSource_Inverse = "http://www.simantics.org/DocumentLink-1.0/hasFunctionalSource/Inverse";
        public static final String hasInstanceSource = "http://www.simantics.org/DocumentLink-1.0/hasInstanceSource";
        public static final String hasInstanceSource_Inverse = "http://www.simantics.org/DocumentLink-1.0/hasInstanceSource/Inverse";
        public static final String hasSource = "http://www.simantics.org/DocumentLink-1.0/hasSource";
        public static final String hasSourceComment = "http://www.simantics.org/DocumentLink-1.0/hasSourceComment";
        public static final String hasSourceComment_Inverse = "http://www.simantics.org/DocumentLink-1.0/hasSourceComment/Inverse";
        public static final String hasSourceReference = "http://www.simantics.org/DocumentLink-1.0/hasSourceReference";
        public static final String hasSourceReferenceURI = "http://www.simantics.org/DocumentLink-1.0/hasSourceReferenceURI";
        public static final String hasSourceReferenceURI_Inverse = "http://www.simantics.org/DocumentLink-1.0/hasSourceReferenceURI/Inverse";
        public static final String hasSource_Inverse = "http://www.simantics.org/DocumentLink-1.0/hasSource/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public DocumentLink(ReadGraph graph) {
        EvaluatorTree = getResourceOrNull(graph, URIs.EvaluatorTree);
        EvaluatorTree_AligmentHint = getResourceOrNull(graph, URIs.EvaluatorTree_AligmentHint);
        EvaluatorTree_And = getResourceOrNull(graph, URIs.EvaluatorTree_And);
        EvaluatorTree_Constant = getResourceOrNull(graph, URIs.EvaluatorTree_Constant);
        EvaluatorTree_Date = getResourceOrNull(graph, URIs.EvaluatorTree_Date);
        EvaluatorTree_HasValue = getResourceOrNull(graph, URIs.EvaluatorTree_HasValue);
        EvaluatorTree_HasValue_Inverse = getResourceOrNull(graph, URIs.EvaluatorTree_HasValue_Inverse);
        EvaluatorTree_If = getResourceOrNull(graph, URIs.EvaluatorTree_If);
        EvaluatorTree_Lines = getResourceOrNull(graph, URIs.EvaluatorTree_Lines);
        EvaluatorTree_Node = getResourceOrNull(graph, URIs.EvaluatorTree_Node);
        EvaluatorTree_Or = getResourceOrNull(graph, URIs.EvaluatorTree_Or);
        EvaluatorTree_Path = getResourceOrNull(graph, URIs.EvaluatorTree_Path);
        EvaluatorTree_Root = getResourceOrNull(graph, URIs.EvaluatorTree_Root);
        EvaluatorTree_Template = getResourceOrNull(graph, URIs.EvaluatorTree_Template);
        EvaluatorTree_TextSizeHint = getResourceOrNull(graph, URIs.EvaluatorTree_TextSizeHint);
        EvaluatorTree_Variable = getResourceOrNull(graph, URIs.EvaluatorTree_Variable);
        FunctionalSource = getResourceOrNull(graph, URIs.FunctionalSource);
        InstanceSource = getResourceOrNull(graph, URIs.InstanceSource);
        ModelViewpointActionContext = getResourceOrNull(graph, URIs.ModelViewpointActionContext);
        ModelViewpointBrowseContext = getResourceOrNull(graph, URIs.ModelViewpointBrowseContext);
        ModelViewpointBrowseContext2 = getResourceOrNull(graph, URIs.ModelViewpointBrowseContext2);
        ModelViewpointBrowseContext2_ChildRule = getResourceOrNull(graph, URIs.ModelViewpointBrowseContext2_ChildRule);
        ModelViewpointBrowseContext_ChildRule = getResourceOrNull(graph, URIs.ModelViewpointBrowseContext_ChildRule);
        ReportTemplate = getResourceOrNull(graph, URIs.ReportTemplate);
        SearchContribution = getResourceOrNull(graph, URIs.SearchContribution);
        SearchFunction = getResourceOrNull(graph, URIs.SearchFunction);
        Source = getResourceOrNull(graph, URIs.Source);
        SourceObjectViewpointActionContext = getResourceOrNull(graph, URIs.SourceObjectViewpointActionContext);
        SourceObjectViewpointActionContext_Category = getResourceOrNull(graph, URIs.SourceObjectViewpointActionContext_Category);
        SourceObjectViewpointBrowseContext = getResourceOrNull(graph, URIs.SourceObjectViewpointBrowseContext);
        SourceObjectViewpointBrowseContext_ChildRule = getResourceOrNull(graph, URIs.SourceObjectViewpointBrowseContext_ChildRule);
        SourcePropertyViewpointActionContext = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext);
        SourcePropertyViewpointActionContext_Category = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_Category);
        SourcePropertyViewpointActionContext_FixAll = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_FixAll);
        SourcePropertyViewpointActionContext_FixAllReferences = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_FixAllReferences);
        SourcePropertyViewpointActionContext_Open = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_Open);
        SourcePropertyViewpointActionContext_OpenWith = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_OpenWith);
        SourcePropertyViewpointActionContext_Remove = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_Remove);
        SourcePropertyViewpointActionContext_RemoveSource = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_RemoveSource);
        SourcePropertyViewpointActionContext_Replace = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_Replace);
        SourcePropertyViewpointActionContext_ReplaceWithLatest = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_ReplaceWithLatest);
        SourcePropertyViewpointActionContext_ShowDocument = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_ShowDocument);
        SourcePropertyViewpointActionContext_ShowDocumentExternal = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_ShowDocumentExternal);
        SourcePropertyViewpointActionContext_SourceObjectDropAction = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_SourceObjectDropAction);
        SourcePropertyViewpointActionContext_SourceReferenceOldTest = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_SourceReferenceOldTest);
        SourcePropertyViewpointActionContext_VariableInstanceTest = getResourceOrNull(graph, URIs.SourcePropertyViewpointActionContext_VariableInstanceTest);
        SourcePropertyViewpointBrowseContext = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext);
        SourcePropertyViewpointBrowseContext_ChildRule = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_ChildRule);
        SourcePropertyViewpointBrowseContext_Variable = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_Variable);
        SourcePropertyViewpointBrowseContext_VariableImageDecorationRule = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_VariableImageDecorationRule);
        SourcePropertyViewpointBrowseContext_VariableImageRule = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_VariableImageRule);
        SourcePropertyViewpointBrowseContext_VariableLabelRule = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_VariableLabelRule);
        SourcePropertyViewpointBrowseContext_VariableModifierRule = getResourceOrNull(graph, URIs.SourcePropertyViewpointBrowseContext_VariableModifierRule);
        consernsRelation = getResourceOrNull(graph, URIs.consernsRelation);
        hasFunctionalSource = getResourceOrNull(graph, URIs.hasFunctionalSource);
        hasFunctionalSource_Inverse = getResourceOrNull(graph, URIs.hasFunctionalSource_Inverse);
        hasInstanceSource = getResourceOrNull(graph, URIs.hasInstanceSource);
        hasInstanceSource_Inverse = getResourceOrNull(graph, URIs.hasInstanceSource_Inverse);
        hasSource = getResourceOrNull(graph, URIs.hasSource);
        hasSourceComment = getResourceOrNull(graph, URIs.hasSourceComment);
        hasSourceComment_Inverse = getResourceOrNull(graph, URIs.hasSourceComment_Inverse);
        hasSourceReference = getResourceOrNull(graph, URIs.hasSourceReference);
        hasSourceReferenceURI = getResourceOrNull(graph, URIs.hasSourceReferenceURI);
        hasSourceReferenceURI_Inverse = getResourceOrNull(graph, URIs.hasSourceReferenceURI_Inverse);
        hasSource_Inverse = getResourceOrNull(graph, URIs.hasSource_Inverse);
    }
    
    public static DocumentLink getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        DocumentLink ret = session.peekService(DocumentLink.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new DocumentLink(qc.getIndependentGraph(graph));
            session.registerService(DocumentLink.class, ret);
        }
        return ret;
    }
    
    public static DocumentLink getInstance(RequestProcessor session) throws DatabaseException {
        DocumentLink ret = session.peekService(DocumentLink.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<DocumentLink>() {
                public DocumentLink perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new DocumentLink(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(DocumentLink.class, ret);
        }
        return ret;
    }
    
}

