/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.Map;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.diagram.profile.ProfileActivityBean;
import org.simantics.diagram.profile.Profiles;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileActivityBeanRepresentation
implements SimanticsClipboard.Representation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileActivityBeanRepresentation.class);
    public static IHintContext.Key KEY = new IHintContext.KeyOf(ProfileActivityBean.class, "PROFILE_ACTIVITY_BEAN");
    private final Resource source;
    private ProfileActivityBean bean;

    public ProfileActivityBeanRepresentation(Resource source) {
        this.source = source;
    }

    public IHintContext.Key getKey() {
        return KEY;
    }

    public <T> T getValue(RequestProcessor processor, Map<String, Object> hints) {
        if (this.bean == null) {
            try {
                this.bean = Profiles.readProfileActivity(processor, this.source);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read profile activity information from model " + String.valueOf(this.source), (Throwable)e);
                this.bean = new ProfileActivityBean();
            }
        }
        return (T)this.bean;
    }
}

