/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.IsInstanceOf;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.handler.ConnectionSplitAndJoin;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteGraphConnectionCommandHandler
extends AbstractDiagramParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteGraphConnectionCommandHandler.class);
    @DependencyReflection.Dependency
    MouseUtil mouseUtil;
    @DependencyReflection.Dependency
    Selection selection;

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleCommand(CommandEvent event) {
        try {
            if (Commands.SPLIT_CONNECTION.equals((Object)event.command)) {
                return this.splitConnection();
            }
            if (Commands.JOIN_FLAGS.equals((Object)event.command)) {
                return this.joinFlags();
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Connection command handling", (Throwable)e);
        }
        return false;
    }

    private boolean splitConnection() throws DatabaseException {
        IElement connection = this.getSingleConnection();
        if (connection == null) {
            return false;
        }
        IDiagram diagram = ElementUtils.peekDiagram((IElement)connection);
        if (diagram == null) {
            return false;
        }
        Object obj = ElementUtils.getData((IDiagram)diagram, (IElement)connection);
        if (!(obj instanceof Resource)) {
            return false;
        }
        Session session = Simantics.getSession();
        Resource conn = (Resource)obj;
        DiagramResource DIA = DiagramResource.getInstance((RequestProcessor)session);
        if (!((Boolean)session.syncRequest((Read)new IsInstanceOf(conn, DIA.RouteGraphConnection))).booleanValue()) {
            return false;
        }
        MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(0);
        new ConnectionSplitAndJoin.SplitRouteGraph(session, this.getContext(), mi.canvasPosition, conn).run();
        return true;
    }

    private IElement getSingleConnection() {
        Set ss = this.selection.getSelection(0);
        if (ss.isEmpty()) {
            return null;
        }
        IElement result = null;
        for (IElement e : ss) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) continue;
            if (result != null && !ce.getConnection().equals(result)) {
                return null;
            }
            result = ce.getConnection();
        }
        return result;
    }

    private boolean joinFlags() throws DatabaseException {
        Resource[] sel = this.getSelectedResources();
        if (sel.length == 0) {
            return false;
        }
        Session session = Simantics.getSession();
        Collection flags = (Collection)session.syncRequest(graph -> ConnectionSplitAndJoin.getLocalConnectedFlags(graph, sel));
        if (flags.isEmpty()) {
            return false;
        }
        new ConnectionSplitAndJoin.Join(session, this.getContext(), flags).run();
        return true;
    }

    private Resource[] getSelectedResources() {
        Set ss = this.selection.getSelection(0);
        if (ss.isEmpty()) {
            return Resource.NONE;
        }
        ArrayList<Resource> result = new ArrayList<Resource>(ss.size());
        for (IElement el : ss) {
            Object obj = ElementUtils.getObject((IElement)el);
            if (!(obj instanceof Resource)) continue;
            result.add((Resource)obj);
        }
        return result.toArray(Resource.NONE);
    }
}

